/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.reloc.org.apache.commons.codec.digest.DigestUtils;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Locator;

public class FileUtils {
    private static final int ZIP_BUFFER = 2048;

    public static boolean isCrashlyticsJar(String filename) {
        return (filename = filename.toLowerCase()).endsWith(".jar") && filename.startsWith("crashlytics-");
    }

    public static void verifyDirectory(File path) throws IOException {
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            throw new IOException("Could not create directory: " + path);
        }
    }

    public static void redirect(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
    }

    public static Thread redirectAsync(final InputStream in, final OutputStream out) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.redirect(in, out);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "Crashlytics Async Redirect");
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void zip(File sourceFile, File destFile, boolean preservePath) throws IOException {
        int count;
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new IllegalArgumentException("Source file does not exist: " + sourceFile);
        }
        BufferedInputStream origin = new BufferedInputStream(new FileInputStream(sourceFile));
        FileOutputStream destOs = new FileOutputStream(destFile);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(destOs));
        byte[] data = new byte[2048];
        String entryPath = preservePath ? sourceFile.toString() : sourceFile.getName();
        ZipEntry entry = new ZipEntry(entryPath);
        out.putNextEntry(entry);
        while ((count = origin.read(data, 0, 2048)) != -1) {
            out.write(data, 0, count);
        }
        origin.close();
        out.close();
    }

    public static void unzip(File zipFile, File outputDir) throws IOException {
        ZipFile zipfile = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            int count;
            ZipEntry entry = e.nextElement();
            BufferedInputStream is = new BufferedInputStream(zipfile.getInputStream(entry));
            byte[] data = new byte[2048];
            FileOutputStream fos = new FileOutputStream(new File(outputDir, entry.getName()));
            BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
            while ((count = ((InputStream)is).read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            ((InputStream)is).close();
        }
    }

    public static void unzipArchive(ZipFile archive, File outputDir) throws IOException {
        Enumeration<? extends ZipEntry> e = archive.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            FileUtils.unzipEntry(archive, entry, outputDir);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            FileUtils.verifyDirectory(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            FileUtils.verifyDirectory(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidZip(File file) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static String unzipToString(File sourceFile) throws IOException {
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + sourceFile);
        }
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(sourceFile)));
        zis.getNextEntry();
        String fileContents = new Scanner(zis).useDelimiter("\\A").next();
        return fileContents;
    }

    public static String fileToString(File sourceFile) throws IOException {
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new FileNotFoundException("source file does not exist: " + sourceFile);
        }
        return FileUtils.streamToString(new FileInputStream(sourceFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream stream) {
        Scanner s = null;
        String contents = null;
        try {
            s = new Scanner(stream, "UTF8").useDelimiter("\\A");
            contents = s.hasNext() ? s.next() : "";
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        return contents;
    }

    public static String getLineSeparator(String contents) {
        int n = contents.indexOf(10);
        int r = contents.indexOf(13);
        if (n < 0) {
            if (r < 0) {
                return System.getProperty("line.separator");
            }
            return "\r";
        }
        if (r >= 0 && n == r + 1) {
            return "\r\n";
        }
        return "\n";
    }

    public static String getLineSeparator(InputStream stream) {
        return FileUtils.getLineSeparator(FileUtils.streamToString(stream));
    }

    public static int locatorCharacterOffset(InputStream stream, Locator locator) throws IOException {
        return FileUtils.characterOffset(stream, locator.getLineNumber() - 1, locator.getColumnNumber() - 1);
    }

    public static int characterOffset(InputStream stream, int lineNum, int column) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        int offset = FileUtils.characterOffset(reader, lineNum, column);
        return offset;
    }

    private static int characterOffset(BufferedReader reader, int targetLine, int targetColumn) throws IOException {
        int linesRead = 0;
        int columnsRead = 0;
        int totalOffset = 0;
        int lastChar = 0;
        int charVal = -1;
        charVal = reader.read();
        while (charVal != -1 && (linesRead != targetLine || targetColumn != columnsRead)) {
            char thisChar = (char)charVal;
            if (thisChar != '\n' && lastChar == 13) {
                ++linesRead;
                columnsRead = 0;
            }
            if (thisChar != '\r') {
                if (thisChar == '\n') {
                    ++linesRead;
                    columnsRead = 0;
                } else {
                    ++columnsRead;
                }
            }
            lastChar = thisChar;
            ++totalOffset;
            charVal = reader.read();
        }
        return totalOffset;
    }

    public static String unqualifiedClassname(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        int lastDot = fullyQualifiedName.lastIndexOf(".");
        if (lastDot > 0) {
            return fullyQualifiedName.substring(lastDot + 1);
        }
        return fullyQualifiedName;
    }

    public static void deleteAndRemakeFolder(File folder) throws IOException {
        if (folder.exists()) {
            com.crashlytics.reloc.org.apache.commons.io.FileUtils.deleteDirectory(folder);
        }
        folder.mkdirs();
    }

    public static String getIdentifier(File file) {
        String returnIdentifier;
        if (file == null) {
            throw new IllegalArgumentException("Crashlytics cannot create a unique identifier from a null file.");
        }
        try {
            returnIdentifier = String.format("%s-%s", file.getName(), DigestUtils.shaHex(file.getCanonicalPath()));
        }
        catch (IOException e) {
            returnIdentifier = String.format("%s-%s", file.getName(), DigestUtils.shaHex(file.getAbsolutePath()));
        }
        return returnIdentifier;
    }

    public static File getResource(String fileName) throws FileNotFoundException {
        File resource = null;
        try {
            URL resourceUrl = FileUtils.class.getClassLoader().getResource(fileName);
            if (resourceUrl != null) {
                resource = new File(resourceUrl.toURI());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (resource == null || !resource.exists()) {
            throw new FileNotFoundException();
        }
        return resource;
    }
}

