/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class GradleTokenizer {
    private final String _data;
    private int _cachedCurrentPosition = 0;
    private int _cachedNumToIncludeInNextToken = 0;
    private int _currentNumToIncludeInNextToken = 0;
    private String _cachedNext = null;
    private int _currentPosition = 0;
    private static final String[] SPECIAL_TOKENS = new String[]{"[", "]", "{", "}", "//", "/*", "*/", ".", "=", "\"\"\"", "\"", "'"};

    public GradleTokenizer(String data) {
        this._data = data;
        this.reset();
    }

    public static GradleTokenizer create(File buildFile) throws IOException {
        return new GradleTokenizer(FileUtils.fileToString(buildFile));
    }

    public int getPosition() {
        return this._currentPosition;
    }

    public String getContents() {
        return this._data;
    }

    public void reset() {
        this.setPosition(0);
    }

    public void setPosition(int newPosition) {
        this._cachedCurrentPosition = newPosition;
        this._cachedNumToIncludeInNextToken = 0;
        this._currentPosition = newPosition;
        this._currentNumToIncludeInNextToken = 0;
        this.cacheNext();
    }

    public String peek() {
        return this._cachedNext;
    }

    public String next() {
        String previousVal = this._cachedNext;
        this._currentPosition = this._cachedCurrentPosition;
        this._currentNumToIncludeInNextToken = this._cachedNumToIncludeInNextToken;
        this.cacheNext();
        return previousVal;
    }

    public void cacheNext() {
        int startPosition = this._cachedCurrentPosition;
        boolean hasReadContent = false;
        block0: while (true) {
            if (this._cachedNumToIncludeInNextToken > 0) {
                --this._cachedNumToIncludeInNextToken;
                ++this._cachedCurrentPosition;
                if (this._cachedNumToIncludeInNextToken != 0) continue;
                break;
            }
            if (this._data.length() <= this._cachedCurrentPosition) break;
            char c = this._data.charAt(this._cachedCurrentPosition);
            if (Character.isWhitespace(c)) {
                if (hasReadContent) break;
                ++this._cachedCurrentPosition;
                continue;
            }
            for (String specialToken : SPECIAL_TOKENS) {
                String stringAtPos;
                int tokenLen = specialToken.length();
                if (this._data.length() + 1 <= this._cachedCurrentPosition + tokenLen || !(stringAtPos = this._data.substring(this._cachedCurrentPosition, this._cachedCurrentPosition + tokenLen)).equals(specialToken)) continue;
                this._cachedNumToIncludeInNextToken = tokenLen;
                if (!hasReadContent) continue block0;
                break block0;
            }
            hasReadContent = true;
            ++this._cachedCurrentPosition;
        }
        this._cachedNext = this._cachedCurrentPosition - startPosition == 0 ? null : this._data.substring(startPosition, this._cachedCurrentPosition);
    }

    public String extractString() {
        int currentPosition;
        String next = this.next().trim();
        QuoteType stringType = null;
        if (QuoteType.DOUBLE_QUOTES.matches(next)) {
            stringType = QuoteType.DOUBLE_QUOTES;
        } else if (QuoteType.SINGLE_QUOTES.matches(next)) {
            stringType = QuoteType.SINGLE_QUOTES;
        } else if (QuoteType.TRIPLE_QUOTES.matches(next)) {
            stringType = QuoteType.TRIPLE_QUOTES;
        } else {
            return null;
        }
        int initialPosition = this._currentPosition;
        boolean escaping = false;
        int charactersOfStringEndingRead = 0;
        for (currentPosition = this._currentPosition; currentPosition < this._data.length(); ++currentPosition) {
            char currentChar = this._data.charAt(currentPosition);
            if (escaping) {
                escaping = false;
                continue;
            }
            if (currentChar == '\'' && QuoteType.SINGLE_QUOTES.equals((Object)stringType)) {
                ++charactersOfStringEndingRead;
                break;
            }
            if (currentChar == '\"' && QuoteType.DOUBLE_QUOTES.equals((Object)stringType)) {
                ++charactersOfStringEndingRead;
                break;
            }
            if (currentChar == '\"' && QuoteType.TRIPLE_QUOTES.equals((Object)stringType)) {
                if (++charactersOfStringEndingRead != 3) continue;
                break;
            }
            if (currentChar == '\\') {
                charactersOfStringEndingRead = 0;
                escaping = true;
                continue;
            }
            charactersOfStringEndingRead = 0;
        }
        int stringEnding = currentPosition - charactersOfStringEndingRead;
        return this._data.substring(initialPosition, stringEnding);
    }

    public String[] tokenize() {
        LinkedList<String> tokens = new LinkedList<String>();
        String next = this.next();
        while (next != null) {
            tokens.add(next);
            next = this.next();
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static enum QuoteType {
        SINGLE_QUOTES("'"),
        DOUBLE_QUOTES("\""),
        TRIPLE_QUOTES("\"\"\"");

        private String _quoteString;

        private QuoteType(String quoteString) {
            this._quoteString = quoteString;
        }

        public boolean matches(String possibleQuoteString) {
            return this._quoteString.equals(possibleQuoteString);
        }
    }
}

