/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.tools.utils.NumberUtils;
import java.util.Date;

public class ReleaseSummary {
    private static final int UNINITIALIZED_NUMBER = -1;
    private static final String RELEASE = "release";
    public final String externalId;
    public final String instanceIdentifier;
    public final long testerCount;
    public final long testerWithInstallCount;
    public final long openInvitationCount;
    public final Date receivedAt;
    public final Date lastActivityAt;
    public final String displayVersion;
    public final String buildVersion;
    public final int buildVersionAsInt;
    public final String accessEnabledFrom;

    public ReleaseSummary(String externalId, String instanceIdentifier, long testerCount, long openInvitationCount, Date receivedAt, Date lastActivityAt, String displayVersion, String buildVersion) {
        this(externalId, instanceIdentifier, testerCount, -1L, openInvitationCount, receivedAt, lastActivityAt, displayVersion, buildVersion, null);
    }

    public ReleaseSummary(String instanceIdentifier, long testerCount, long testerWithInstallCount, long openInvitationCount, Date distributedAt, String displayVersion, String buildVersion) {
        this(null, instanceIdentifier, testerCount, testerWithInstallCount, openInvitationCount, distributedAt, null, displayVersion, buildVersion, null);
    }

    public ReleaseSummary(String instanceIdentifier, Date distributedAt, String displayVersion, String buildVersion, String accessEnabledFrom) {
        this(null, instanceIdentifier, -1L, -1L, -1L, distributedAt, null, displayVersion, buildVersion, accessEnabledFrom);
    }

    private ReleaseSummary(String externalId, String instanceIdentifier, long testerCount, long testerWithInstallCount, long openInvitationCount, Date receivedAt, Date lastActivityAt, String displayVersion, String buildVersion, String accessEnabledFrom) {
        this.externalId = externalId;
        this.instanceIdentifier = instanceIdentifier;
        this.testerCount = testerCount;
        this.testerWithInstallCount = testerWithInstallCount;
        this.openInvitationCount = openInvitationCount;
        this.receivedAt = receivedAt;
        this.lastActivityAt = lastActivityAt;
        this.displayVersion = displayVersion;
        this.buildVersion = buildVersion;
        this.buildVersionAsInt = NumberUtils.toInt(buildVersion, 0);
        this.accessEnabledFrom = accessEnabledFrom;
    }

    public long getPeopleCount() {
        return this.testerCount + this.openInvitationCount;
    }

    public boolean isAccessEnabledFromRelease() {
        return RELEASE.equals(this.accessEnabledFrom);
    }
}

