/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.ant;

import com.crashlytics.reloc.org.apache.ivy.core.settings.IvyVariableContainer;
import com.crashlytics.reloc.org.apache.ivy.core.settings.IvyVariableContainerImpl;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.tools.ant.Project;
import com.crashlytics.reloc.org.apache.tools.ant.taskdefs.Property;
import java.util.HashMap;
import java.util.Map;

class IvyAntVariableContainer
extends IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map overwrittenProperties = new HashMap();
    private Project project;

    public IvyAntVariableContainer(Project project) {
        this.project = project;
    }

    public String getVariable(String name) {
        String r = (String)this.overwrittenProperties.get(name);
        if (r == null) {
            r = this.project.getProperty(name);
        }
        if (r == null) {
            r = super.getVariable(name);
        }
        return r;
    }

    public void setVariable(String varName, String value, boolean overwrite) {
        if (overwrite) {
            Message.debug("setting '" + varName + "' to '" + value + "'");
            this.overwrittenProperties.put(varName, this.substitute(value));
        } else {
            super.setVariable(varName, value, overwrite);
        }
    }

    public void updateProject(String id) {
        HashMap r = new HashMap(super.getVariables());
        r.putAll(this.overwrittenProperties);
        for (Map.Entry entry : r.entrySet()) {
            this.setPropertyIfNotSet((String)entry.getKey(), (String)entry.getValue());
            if (id == null) continue;
            this.setPropertyIfNotSet((String)entry.getKey() + "." + id, (String)entry.getValue());
        }
        if (this.getEnvironmentPrefix() != null) {
            Property propTask = new Property();
            propTask.setProject(this.project);
            propTask.setEnvironment(this.getEnvironmentPrefix());
            propTask.init();
            propTask.execute();
        }
    }

    private void setPropertyIfNotSet(String property, String value) {
        if (this.project.getProperty(property) == null) {
            this.project.setProperty(property, value);
        }
    }

    public Object clone() {
        IvyAntVariableContainer result = (IvyAntVariableContainer)super.clone();
        result.overwrittenProperties = (HashMap)((HashMap)this.overwrittenProperties).clone();
        return result;
    }
}

