/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class TwitterAuthCodeBlockFactory {
    public static final String DEFAULT_KEY = "TWITTER_KEY";
    public static final String DEFAULT_SECRET = "TWITTER_SECRET";
    public static final String AUTH_CONFIG_INITIALIZATION = "final TwitterAuthConfig authConfig = new TwitterAuthConfig(TWITTER_KEY, TWITTER_SECRET);";

    public static Collection<? extends String> getImports() {
        LinkedList<String> importStrings = new LinkedList<String>();
        importStrings.add("android.content.Intent");
        importStrings.add("com.twitter.sdk.android.core.Callback");
        importStrings.add("com.twitter.sdk.android.core.Result");
        importStrings.add("com.twitter.sdk.android.core.TwitterException");
        importStrings.add("com.twitter.sdk.android.core.TwitterSession");
        importStrings.add("com.twitter.sdk.android.core.identity.TwitterLoginButton");
        return importStrings;
    }

    public static String getVariableDeclarationCode(String tab) {
        return "\n" + TwitterAuthCodeBlockFactory.indentString(1, tab, "private TwitterLoginButton loginButton;\n");
    }

    public static String getAuthDeclarationCode(String tab, String key, String secret) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, TwitterAuthCodeBlockFactory.getObfuscationComment() + "\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, TwitterAuthCodeBlockFactory.getTwitterKeyConstant(key) + "\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, TwitterAuthCodeBlockFactory.getTwitterSecretConstant(secret)));
        return builder.toString();
    }

    public static String getObfuscationComment() {
        return "// Note: Your consumer key and secret should be obfuscated in your source code before shipping.";
    }

    public static String getTwitterKeyConstant(String key) {
        return "private static final String TWITTER_KEY = \"" + key + "\";";
    }

    public static String getTwitterSecretConstant(String secret) {
        return "private static final String TWITTER_SECRET = \"" + secret + "\";";
    }

    public static String getVariableInitializationCode(String tab) {
        return "\n\n" + TwitterAuthCodeBlockFactory.indentString(2, tab, "final TwitterAuthConfig authConfig = new TwitterAuthConfig(TWITTER_KEY, TWITTER_SECRET);\n") + TwitterAuthCodeBlockFactory.indentString(2, tab, "");
    }

    public static String getLayoutManipulationCode(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "loginButton = (TwitterLoginButton) findViewById(R.id.twitter_login_button);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "loginButton.setCallback(new Callback<TwitterSession>() {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "public void success(Result<TwitterSession> result) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(4, tab, "// Do something with result, which provides a TwitterSession for making API calls\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "}\n"));
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "public void failure(TwitterException exception) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(4, tab, "// Do something on failure\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(3, tab, "}\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "});\n"));
        return builder.toString();
    }

    public static String getExtraMethods(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "protected void onActivityResult(int requestCode, int resultCode, Intent data) {\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "super.onActivityResult(requestCode, resultCode, data);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(2, tab, "loginButton.onActivityResult(requestCode, resultCode, data);\n"));
        builder.append(TwitterAuthCodeBlockFactory.indentString(1, tab, "}\n"));
        return builder.toString();
    }

    public static CodeChange getManualCodeDirections(String javaFileContents) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("import android.app.Activity;", javaFileContents, TwitterAuthCodeBlockFactory.createImports(TwitterAuthCodeBlockFactory.getImports())));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("public class MainActivity extends Activity {", javaFileContents, TwitterAuthCodeBlockFactory.getVariableDeclarationCode("\t")));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);", javaFileContents, TwitterAuthCodeBlockFactory.getLayoutManipulationCode("\t")));
        changes.add(TwitterAuthCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);\n  }", javaFileContents, TwitterAuthCodeBlockFactory.getExtraMethods("\t")));
        return new CodeChange("View Class", new StubCode(javaFileContents), changes);
    }

    private static String createImports(Collection<? extends String> imports) {
        StringBuilder builder = new StringBuilder();
        for (String string : imports) {
            builder.append("import " + string + ";\n");
        }
        return builder.toString();
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length() + 1, toAdd);
    }

    public static String getLoginButton(String newlineIdented) {
        Joiner joiner = Joiner.on(newlineIdented);
        return joiner.join("    <com.twitter.sdk.android.core.identity.TwitterLoginButton", "android:id=\"@+id/twitter_login_button\"", "android:layout_width=\"wrap_content\"", "android:layout_height=\"wrap_content\"", "android:layout_centerInParent=\"true\"/>");
    }

    public static CodeChange getManualLayoutDirections(String viewFileContents) {
        String layoutElementcontent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterAuthCodeBlockFactory.injectAfter(layoutElementcontent, viewFileContents, TwitterAuthCodeBlockFactory.getLoginButton("\n        "))));
    }

    private static String indentString(int tabs, String tab, String string) {
        return Strings.repeat(tab, tabs) + string;
    }
}

