/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.reloc.com.google.common.io.Files;
import com.crashlytics.reloc.org.apache.commons.io.FileUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.library.AndroidLibrary;
import com.crashlytics.tools.android.project.library.AndroidLibraryProject;
import com.crashlytics.tools.android.project.library.ProjectProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.ZipFile;

public class ProjectBuilder {
    public void createProject(AndroidLibrary library, File projectDir, File rootDir, int userTargetPlatform, Iterable<AndroidLibrary> jarDependencies, Iterable<AndroidLibrary> aarDependencies, Map<String, String> projectNames) throws IOException {
        DeveloperTools.logD("Creating project with the following properties:");
        DeveloperTools.logD("Zip File: " + library.file);
        DeveloperTools.logD("Library Project Dir : " + projectDir);
        DeveloperTools.logD("Dependencies: " + aarDependencies);
        DeveloperTools.logD("Jars: " + jarDependencies);
        File projectPropsFile = new File(projectDir, "project.properties");
        File classesFile = new File(projectDir, "classes.jar");
        File libsFolder = new File(projectDir, "libs");
        File srcFolder = new File(projectDir, "src");
        File androidManifestFile = new File(projectDir, "AndroidManifest.xml");
        File antBuildFile = new File(projectDir, "build.xml");
        com.crashlytics.tools.utils.FileUtils.unzipArchive(new ZipFile(library.file), projectDir);
        com.crashlytics.tools.utils.FileUtils.mkdirs(libsFolder);
        com.crashlytics.tools.utils.FileUtils.mkdirs(srcFolder);
        File classesInLibs = new File(libsFolder, library.name + "-classes.jar");
        Files.move(classesFile, classesInLibs);
        for (AndroidLibrary jarDep : jarDependencies) {
            com.crashlytics.tools.utils.FileUtils.copyFile(jarDep.file, new File(libsFolder, jarDep.name + ".jar"));
        }
        InputStream stream = ProjectBuilder.class.getClassLoader().getResourceAsStream("build.xml");
        FileUtils.writeStringToFile(antBuildFile, com.crashlytics.tools.utils.FileUtils.streamToString(stream));
        projectPropsFile.createNewFile();
        ProjectProperties properties = ProjectProperties.getKitProperties(projectPropsFile);
        AndroidLibraryProject project = new AndroidLibraryProject(projectDir, projectPropsFile, classesFile, libsFolder, srcFolder, androidManifestFile);
        int targetPlatform = Math.max(userTargetPlatform, project.getTargetPlatform());
        properties.configureLibrary(aarDependencies, targetPlatform, projectNames);
        AndroidLibraryProject.writeKitInfo(new File(projectDir, "kit-version.properties"), library);
        DeveloperTools.logD("Created Project " + project);
    }
}

