/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.dwarf;

import com.crashlytics.reloc.com.google.common.base.Charsets;
import com.crashlytics.tools.utils.dwarf.DebugLineContext;
import com.crashlytics.tools.utils.dwarf.DebugLineEntry;
import com.crashlytics.tools.utils.dwarf.DebugLineHeader;
import com.crashlytics.tools.utils.dwarf.DebugLineOpcode;
import com.crashlytics.tools.utils.dwarf.DebugLineRegisters;
import com.crashlytics.tools.utils.dwarf.ExtendedOpcodeDefineFile;
import com.crashlytics.tools.utils.dwarf.ExtendedOpcodeEndSequence;
import com.crashlytics.tools.utils.dwarf.ExtendedOpcodeSetAddress;
import com.crashlytics.tools.utils.dwarf.ExtendedOpcodeSetDiscriminator;
import com.crashlytics.tools.utils.dwarf.SpecialOpcode;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeAdvanceLine;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeAdvancePC;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeConstAddPC;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeCopy;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeFixedAdvancePC;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeNegateStatement;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeSetBasicBlock;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeSetColumn;
import com.crashlytics.tools.utils.dwarf.StandardOpcodeSetFile;
import com.crashlytics.tools.utils.io.ByteReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class DebugLineStateMachine {
    private static final int EXTENDED_OPCODE = 0;
    private static final DebugLineOpcode[] STANDARD_OPCODES = new DebugLineOpcode[]{null, new StandardOpcodeCopy(), new StandardOpcodeAdvancePC(), new StandardOpcodeAdvanceLine(), new StandardOpcodeSetFile(), new StandardOpcodeSetColumn(), new StandardOpcodeNegateStatement(), new StandardOpcodeSetBasicBlock(), new StandardOpcodeConstAddPC(), new StandardOpcodeFixedAdvancePC()};
    private static final DebugLineOpcode[] EXTENDED_OPCODES = new DebugLineOpcode[]{null, new ExtendedOpcodeEndSequence(), new ExtendedOpcodeSetAddress(), new ExtendedOpcodeDefineFile(), new ExtendedOpcodeSetDiscriminator()};
    private boolean _dwarf64 = false;

    public List<DebugLineEntry> run(ByteReader reader) throws IOException {
        long beginOffset = reader.getCurrentOffset();
        DebugLineContext context = this.configureContext(reader);
        return this.readCompilationUnit(context, reader, beginOffset);
    }

    private DebugLineContext configureContext(ByteReader dataReader) throws IOException {
        long unitLength = this.readInitialLength(dataReader);
        int offsetSize = this._dwarf64 ? 8 : 4;
        int version = dataReader.readInt(2);
        long headerLength = dataReader.readLong(offsetSize);
        byte minInstructionLength = dataReader.readByte();
        boolean defaultIsStatement = dataReader.readByte() != 0;
        byte lineBase = dataReader.readByte();
        byte lineRange = dataReader.readByte();
        byte by = dataReader.readByte();
        byte[] standardOpcodeLengths = new byte[by];
        for (int i = 1; i < by; ++i) {
            standardOpcodeLengths[i] = dataReader.readByte();
        }
        DebugLineHeader header = new DebugLineHeader(unitLength, version, headerLength, minInstructionLength, defaultIsStatement, lineBase, lineRange, by, standardOpcodeLengths);
        DebugLineRegisters registers = new DebugLineRegisters(defaultIsStatement);
        DebugLineContext context = new DebugLineContext(header, registers, offsetSize);
        String directory = dataReader.readNullTerminatedString(Charsets.UTF_8);
        while (directory.length() > 0) {
            context.defineDirectory(directory);
            directory = dataReader.readNullTerminatedString(Charsets.UTF_8);
        }
        String fileName = dataReader.readNullTerminatedString(Charsets.UTF_8);
        while (fileName.length() > 0) {
            int dirIndex = dataReader.readULEB128();
            int modTime = dataReader.readULEB128();
            int length = dataReader.readULEB128();
            context.defineFile(fileName, dirIndex, modTime, length);
            fileName = dataReader.readNullTerminatedString(Charsets.UTF_8);
        }
        return context;
    }

    private List<DebugLineEntry> readCompilationUnit(DebugLineContext context, ByteReader dataReader, long beginOffset) throws IOException {
        LinkedList<DebugLineEntry> data = new LinkedList<DebugLineEntry>();
        int initialLength = this._dwarf64 ? 12 : 4;
        long nextOffset = beginOffset + (long)initialLength + context.header.unitLength;
        while (dataReader.getCurrentOffset() < nextOffset) {
            boolean addRow = this.processOpcode(context, dataReader);
            if (addRow) {
                long address = context.reg.address;
                String file = context.getFileName(context.reg.file);
                long lineNumber = context.reg.line;
                data.add(new DebugLineEntry(address, file, lineNumber));
            }
            if (!context.reg.isEndSequence) continue;
            context.reg.reset();
        }
        return data;
    }

    private boolean processOpcode(DebugLineContext context, ByteReader dataReader) throws IOException {
        DebugLineOpcode debugLineOpcode;
        int opcode = dataReader.readInt(1);
        if (opcode < 0) {
            throw new IllegalArgumentException("Could not process opcode " + opcode);
        }
        if (opcode >= context.header.opcodeBase) {
            debugLineOpcode = new SpecialOpcode(opcode);
        } else if (opcode == 0) {
            int length = dataReader.readULEB128();
            int exOpcode = dataReader.readInt(1);
            debugLineOpcode = EXTENDED_OPCODES[exOpcode];
        } else {
            debugLineOpcode = STANDARD_OPCODES[opcode];
        }
        return debugLineOpcode.process(context, dataReader);
    }

    private long readInitialLength(ByteReader dataReader) throws IOException {
        long initialLength = dataReader.readLong(4);
        if (initialLength == -1L) {
            this._dwarf64 = true;
            initialLength = dataReader.readLong(8);
        }
        return initialLength;
    }
}

