/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.PodSpec;
import io.fabric8.camelk.v1.PodSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>>
extends BaseFluent<A>
implements PodSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private String dnsPolicy;
    private List<EphemeralContainer> ephemeralContainers = new ArrayList<EphemeralContainer>();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Map<String, String> nodeSelector;
    private String restartPolicy;
    private Long terminationGracePeriodSeconds;
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEphemeralContainers(instance.getEphemeralContainers());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public A addToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"containers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"containers").size(), builder);
        this.containers.add(index >= 0 ? index.intValue() : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containers").size()) {
            this._visitables.get((Object)"containers").add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return this.containers != null ? PodSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public List<Container> buildContainers() {
        return this.containers != null ? PodSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public Container buildContainer(Integer index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> setNewContainerLike(Integer index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editContainer(Integer index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    public A addToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        this.ephemeralContainers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
        }
        for (EphemeralContainer item : items) {
            this.ephemeralContainers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    @Override
    public EphemeralContainer getEphemeralContainer(Integer index) {
        return this.ephemeralContainers.get(index);
    }

    @Override
    public EphemeralContainer getFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0);
    }

    @Override
    public EphemeralContainer getLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1);
    }

    @Override
    public EphemeralContainer getMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainer> predicate) {
        for (EphemeralContainer item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList<EphemeralContainer>();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    @Override
    public A addToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"initContainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index.intValue() : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"initContainers").size()) {
            this._visitables.get((Object)"initContainers").add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return this.initContainers != null ? PodSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public List<Container> buildInitContainers() {
        return this.initContainers != null ? PodSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public Container buildInitContainer(Integer index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public A addToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(Integer index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public A addToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return this.volumes != null ? PodSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public List<Volume> buildVolumes() {
        return this.volumes != null ? PodSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public Volume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSpecFluentImpl that = (PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.ephemeralContainers != null ? !this.ephemeralContainers.equals(that.ephemeralContainers) : that.ephemeralContainers != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.containers, this.dnsPolicy, this.ephemeralContainers, this.initContainers, this.nodeSelector, this.restartPolicy, this.terminationGracePeriodSeconds, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>>
    implements PodSpecFluent.VolumesNested<N>,
    Nested<N> {
        VolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>>
    implements PodSpecFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        InitContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    class ContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>>
    implements PodSpecFluent.ContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        ContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

