/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.certmanager.api.model.v1.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresFluentImpl;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKey;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKeyBuilder;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKeyFluentImpl;
import io.fabric8.certmanager.api.model.v1.CertificateSpec;
import io.fabric8.certmanager.api.model.v1.CertificateSpecFluent;
import io.fabric8.certmanager.api.model.v1.X509Subject;
import io.fabric8.certmanager.api.model.v1.X509SubjectBuilder;
import io.fabric8.certmanager.api.model.v1.X509SubjectFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateSpecFluentImpl<A extends CertificateSpecFluent<A>>
extends BaseFluent<A>
implements CertificateSpecFluent<A> {
    private String commonName;
    private List<String> dnsNames;
    private Duration duration;
    private List<String> emailAddresses;
    private Boolean encodeUsagesInRequest;
    private List<String> ipAddresses;
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private CertificateKeystoresBuilder keystores;
    private CertificatePrivateKeyBuilder privateKey;
    private Duration renewBefore;
    private String secretName;
    private X509SubjectBuilder subject;
    private List<String> uris;
    private List<String> usages;

    public CertificateSpecFluentImpl() {
    }

    public CertificateSpecFluentImpl(CertificateSpec instance) {
        this.withCommonName(instance.getCommonName());
        this.withDnsNames(instance.getDnsNames());
        this.withDuration(instance.getDuration());
        this.withEmailAddresses(instance.getEmailAddresses());
        this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
        this.withIpAddresses(instance.getIpAddresses());
        this.withIsCA(instance.getIsCA());
        this.withIssuerRef(instance.getIssuerRef());
        this.withKeystores(instance.getKeystores());
        this.withPrivateKey(instance.getPrivateKey());
        this.withRenewBefore(instance.getRenewBefore());
        this.withSecretName(instance.getSecretName());
        this.withSubject(instance.getSubject());
        this.withUris(instance.getUris());
        this.withUsages(instance.getUsages());
    }

    @Override
    public String getCommonName() {
        return this.commonName;
    }

    @Override
    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)this;
    }

    @Override
    public Boolean hasCommonName() {
        return this.commonName != null;
    }

    @Override
    @Deprecated
    public A withNewCommonName(String arg0) {
        return this.withCommonName(new String(arg0));
    }

    @Override
    public A addToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsNames(String ... items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsNames(Collection<String> items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    public String getDnsName(Integer index) {
        return this.dnsNames.get(index);
    }

    @Override
    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    @Override
    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    @Override
    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)this;
    }

    @Override
    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    @Override
    public A addNewDnsName(String arg0) {
        return this.addToDnsNames(new String(arg0));
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public A addToEmailAddresses(Integer index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEmailAddresses(Integer index, String item) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEmailAddresses(String ... items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEmailAddresses(Collection<String> items) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.emailAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEmailAddresses(String ... items) {
        for (String item : items) {
            if (this.emailAddresses == null) continue;
            this.emailAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEmailAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.emailAddresses == null) continue;
            this.emailAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    @Override
    public String getEmailAddress(Integer index) {
        return this.emailAddresses.get(index);
    }

    @Override
    public String getFirstEmailAddress() {
        return this.emailAddresses.get(0);
    }

    @Override
    public String getLastEmailAddress() {
        return this.emailAddresses.get(this.emailAddresses.size() - 1);
    }

    @Override
    public String getMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEmailAddress(Predicate<String> predicate) {
        for (String item : this.emailAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEmailAddresses(List<String> emailAddresses) {
        if (emailAddresses != null) {
            this.emailAddresses = new ArrayList<String>();
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        } else {
            this.emailAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withEmailAddresses(String ... emailAddresses) {
        if (this.emailAddresses != null) {
            this.emailAddresses.clear();
        }
        if (emailAddresses != null) {
            for (String item : emailAddresses) {
                this.addToEmailAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEmailAddresses() {
        return this.emailAddresses != null && !this.emailAddresses.isEmpty();
    }

    @Override
    public A addNewEmailAddress(String arg0) {
        return this.addToEmailAddresses(new String(arg0));
    }

    @Override
    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    @Override
    public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        return (A)this;
    }

    @Override
    public Boolean hasEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null;
    }

    @Override
    public A addToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpAddresses(String ... items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    @Override
    public String getIpAddress(Integer index) {
        return this.ipAddresses.get(index);
    }

    @Override
    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    @Override
    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    @Override
    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    @Override
    public A addNewIpAddress(String arg0) {
        return this.addToIpAddresses(new String(arg0));
    }

    @Override
    public Boolean getIsCA() {
        return this.isCA;
    }

    @Override
    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)this;
    }

    @Override
    public Boolean hasIsCA() {
        return this.isCA != null;
    }

    @Override
    @Deprecated
    public ObjectReference getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    @Override
    public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public CertificateSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    @Deprecated
    public CertificateKeystores getKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    @Override
    public CertificateKeystores buildKeystores() {
        return this.keystores != null ? this.keystores.build() : null;
    }

    @Override
    public A withKeystores(CertificateKeystores keystores) {
        this._visitables.get((Object)"keystores").remove(this.keystores);
        if (keystores != null) {
            this.keystores = new CertificateKeystoresBuilder(keystores);
            this._visitables.get((Object)"keystores").add(this.keystores);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeystores() {
        return this.keystores != null;
    }

    @Override
    public CertificateSpecFluent.KeystoresNested<A> withNewKeystores() {
        return new KeystoresNestedImpl();
    }

    @Override
    public CertificateSpecFluent.KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
        return new KeystoresNestedImpl(item);
    }

    @Override
    public CertificateSpecFluent.KeystoresNested<A> editKeystores() {
        return this.withNewKeystoresLike(this.getKeystores());
    }

    @Override
    public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystores() {
        return this.withNewKeystoresLike(this.getKeystores() != null ? this.getKeystores() : new CertificateKeystoresBuilder().build());
    }

    @Override
    public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
        return this.withNewKeystoresLike(this.getKeystores() != null ? this.getKeystores() : item);
    }

    @Override
    @Deprecated
    public CertificatePrivateKey getPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    @Override
    public CertificatePrivateKey buildPrivateKey() {
        return this.privateKey != null ? this.privateKey.build() : null;
    }

    @Override
    public A withPrivateKey(CertificatePrivateKey privateKey) {
        this._visitables.get((Object)"privateKey").remove(this.privateKey);
        if (privateKey != null) {
            this.privateKey = new CertificatePrivateKeyBuilder(privateKey);
            this._visitables.get((Object)"privateKey").add(this.privateKey);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    @Override
    public A withNewPrivateKey(String algorithm, String encoding, String rotationPolicy, Integer size) {
        return this.withPrivateKey(new CertificatePrivateKey(algorithm, encoding, rotationPolicy, size));
    }

    @Override
    public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKey() {
        return new PrivateKeyNestedImpl();
    }

    @Override
    public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
        return new PrivateKeyNestedImpl(item);
    }

    @Override
    public CertificateSpecFluent.PrivateKeyNested<A> editPrivateKey() {
        return this.withNewPrivateKeyLike(this.getPrivateKey());
    }

    @Override
    public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKey() {
        return this.withNewPrivateKeyLike(this.getPrivateKey() != null ? this.getPrivateKey() : new CertificatePrivateKeyBuilder().build());
    }

    @Override
    public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
        return this.withNewPrivateKeyLike(this.getPrivateKey() != null ? this.getPrivateKey() : item);
    }

    @Override
    public Duration getRenewBefore() {
        return this.renewBefore;
    }

    @Override
    public A withRenewBefore(Duration renewBefore) {
        this.renewBefore = renewBefore;
        return (A)this;
    }

    @Override
    public Boolean hasRenewBefore() {
        return this.renewBefore != null;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    @Deprecated
    public A withNewSecretName(String arg0) {
        return this.withSecretName(new String(arg0));
    }

    @Override
    @Deprecated
    public X509Subject getSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public X509Subject buildSubject() {
        return this.subject != null ? this.subject.build() : null;
    }

    @Override
    public A withSubject(X509Subject subject) {
        this._visitables.get((Object)"subject").remove(this.subject);
        if (subject != null) {
            this.subject = new X509SubjectBuilder(subject);
            this._visitables.get((Object)"subject").add(this.subject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubject() {
        return this.subject != null;
    }

    @Override
    public CertificateSpecFluent.SubjectNested<A> withNewSubject() {
        return new SubjectNestedImpl();
    }

    @Override
    public CertificateSpecFluent.SubjectNested<A> withNewSubjectLike(X509Subject item) {
        return new SubjectNestedImpl(item);
    }

    @Override
    public CertificateSpecFluent.SubjectNested<A> editSubject() {
        return this.withNewSubjectLike(this.getSubject());
    }

    @Override
    public CertificateSpecFluent.SubjectNested<A> editOrNewSubject() {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : new X509SubjectBuilder().build());
    }

    @Override
    public CertificateSpecFluent.SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
        return this.withNewSubjectLike(this.getSubject() != null ? this.getSubject() : item);
    }

    @Override
    public A addToUris(Integer index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUris(Integer index, String item) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        this.uris.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUris(String ... items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUris(Collection<String> items) {
        if (this.uris == null) {
            this.uris = new ArrayList<String>();
        }
        for (String item : items) {
            this.uris.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUris(String ... items) {
        for (String item : items) {
            if (this.uris == null) continue;
            this.uris.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUris(Collection<String> items) {
        for (String item : items) {
            if (this.uris == null) continue;
            this.uris.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUris() {
        return this.uris;
    }

    @Override
    public String getUri(Integer index) {
        return this.uris.get(index);
    }

    @Override
    public String getFirstUri() {
        return this.uris.get(0);
    }

    @Override
    public String getLastUri() {
        return this.uris.get(this.uris.size() - 1);
    }

    @Override
    public String getMatchingUri(Predicate<String> predicate) {
        for (String item : this.uris) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUri(Predicate<String> predicate) {
        for (String item : this.uris) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUris(List<String> uris) {
        if (uris != null) {
            this.uris = new ArrayList<String>();
            for (String item : uris) {
                this.addToUris(item);
            }
        } else {
            this.uris = null;
        }
        return (A)this;
    }

    @Override
    public A withUris(String ... uris) {
        if (this.uris != null) {
            this.uris.clear();
        }
        if (uris != null) {
            for (String item : uris) {
                this.addToUris(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUris() {
        return this.uris != null && !this.uris.isEmpty();
    }

    @Override
    public A addNewUri(String arg0) {
        return this.addToUris(new String(arg0));
    }

    @Override
    public A addToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(Integer index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsages() {
        return this.usages;
    }

    @Override
    public String getUsage(Integer index) {
        return this.usages.get(index);
    }

    @Override
    public String getFirstUsage() {
        return this.usages.get(0);
    }

    @Override
    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    @Override
    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    public A addNewUsage(String arg0) {
        return this.addToUsages(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateSpecFluentImpl that = (CertificateSpecFluentImpl)o;
        if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) {
            return false;
        }
        if (this.dnsNames != null ? !this.dnsNames.equals(that.dnsNames) : that.dnsNames != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals((Object)that.duration) : that.duration != null) {
            return false;
        }
        if (this.emailAddresses != null ? !this.emailAddresses.equals(that.emailAddresses) : that.emailAddresses != null) {
            return false;
        }
        if (this.encodeUsagesInRequest != null ? !this.encodeUsagesInRequest.equals(that.encodeUsagesInRequest) : that.encodeUsagesInRequest != null) {
            return false;
        }
        if (this.ipAddresses != null ? !this.ipAddresses.equals(that.ipAddresses) : that.ipAddresses != null) {
            return false;
        }
        if (this.isCA != null ? !this.isCA.equals(that.isCA) : that.isCA != null) {
            return false;
        }
        if (this.issuerRef != null ? !this.issuerRef.equals(that.issuerRef) : that.issuerRef != null) {
            return false;
        }
        if (this.keystores != null ? !this.keystores.equals(that.keystores) : that.keystores != null) {
            return false;
        }
        if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) {
            return false;
        }
        if (this.renewBefore != null ? !this.renewBefore.equals((Object)that.renewBefore) : that.renewBefore != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
            return false;
        }
        if (this.uris != null ? !this.uris.equals(that.uris) : that.uris != null) {
            return false;
        }
        return !(this.usages != null ? !this.usages.equals(that.usages) : that.usages != null);
    }

    public int hashCode() {
        return Objects.hash(this.commonName, this.dnsNames, this.duration, this.emailAddresses, this.encodeUsagesInRequest, this.ipAddresses, this.isCA, this.issuerRef, this.keystores, this.privateKey, this.renewBefore, this.secretName, this.subject, this.uris, this.usages, super.hashCode());
    }

    public class SubjectNestedImpl<N>
    extends X509SubjectFluentImpl<CertificateSpecFluent.SubjectNested<N>>
    implements CertificateSpecFluent.SubjectNested<N>,
    Nested<N> {
        X509SubjectBuilder builder;

        SubjectNestedImpl(X509Subject item) {
            this.builder = new X509SubjectBuilder(this, item);
        }

        SubjectNestedImpl() {
            this.builder = new X509SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateSpecFluentImpl.this.withSubject(this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class PrivateKeyNestedImpl<N>
    extends CertificatePrivateKeyFluentImpl<CertificateSpecFluent.PrivateKeyNested<N>>
    implements CertificateSpecFluent.PrivateKeyNested<N>,
    Nested<N> {
        CertificatePrivateKeyBuilder builder;

        PrivateKeyNestedImpl(CertificatePrivateKey item) {
            this.builder = new CertificatePrivateKeyBuilder(this, item);
        }

        PrivateKeyNestedImpl() {
            this.builder = new CertificatePrivateKeyBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateSpecFluentImpl.this.withPrivateKey(this.builder.build());
        }

        @Override
        public N endPrivateKey() {
            return this.and();
        }
    }

    public class KeystoresNestedImpl<N>
    extends CertificateKeystoresFluentImpl<CertificateSpecFluent.KeystoresNested<N>>
    implements CertificateSpecFluent.KeystoresNested<N>,
    Nested<N> {
        CertificateKeystoresBuilder builder;

        KeystoresNestedImpl(CertificateKeystores item) {
            this.builder = new CertificateKeystoresBuilder(this, item);
        }

        KeystoresNestedImpl() {
            this.builder = new CertificateKeystoresBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateSpecFluentImpl.this.withKeystores(this.builder.build());
        }

        @Override
        public N endKeystores() {
            return this.and();
        }
    }

    public class IssuerRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<CertificateSpecFluent.IssuerRefNested<N>>
    implements CertificateSpecFluent.IssuerRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateSpecFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

