/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1beta1;

import io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpec;
import io.fabric8.certmanager.api.model.acme.v1beta1.OrderSpecFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OrderSpecFluentImpl<A extends OrderSpecFluent<A>>
extends BaseFluent<A>
implements OrderSpecFluent<A> {
    private String commonName;
    private List<String> dnsNames;
    private Duration duration;
    private List<String> ipAddresses;
    private ObjectReferenceBuilder issuerRef;
    private List<Integer> request;

    public OrderSpecFluentImpl() {
    }

    public OrderSpecFluentImpl(OrderSpec instance) {
        this.withCommonName(instance.getCommonName());
        this.withDnsNames(instance.getDnsNames());
        this.withDuration(instance.getDuration());
        this.withIpAddresses(instance.getIpAddresses());
        this.withIssuerRef(instance.getIssuerRef());
        this.withRequest(instance.getRequest());
    }

    @Override
    public String getCommonName() {
        return this.commonName;
    }

    @Override
    public A withCommonName(String commonName) {
        this.commonName = commonName;
        return (A)this;
    }

    @Override
    public Boolean hasCommonName() {
        return this.commonName != null;
    }

    @Override
    @Deprecated
    public A withNewCommonName(String arg0) {
        return this.withCommonName(new String(arg0));
    }

    @Override
    public A addToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDnsNames(Integer index, String item) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDnsNames(String ... items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDnsNames(Collection<String> items) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.dnsNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDnsNames(String ... items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDnsNames(Collection<String> items) {
        for (String item : items) {
            if (this.dnsNames == null) continue;
            this.dnsNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    public String getDnsName(Integer index) {
        return this.dnsNames.get(index);
    }

    @Override
    public String getFirstDnsName() {
        return this.dnsNames.get(0);
    }

    @Override
    public String getLastDnsName() {
        return this.dnsNames.get(this.dnsNames.size() - 1);
    }

    @Override
    public String getMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDnsName(Predicate<String> predicate) {
        for (String item : this.dnsNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDnsNames(List<String> dnsNames) {
        if (dnsNames != null) {
            this.dnsNames = new ArrayList<String>();
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        } else {
            this.dnsNames = null;
        }
        return (A)this;
    }

    @Override
    public A withDnsNames(String ... dnsNames) {
        if (this.dnsNames != null) {
            this.dnsNames.clear();
        }
        if (dnsNames != null) {
            for (String item : dnsNames) {
                this.addToDnsNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsNames() {
        return this.dnsNames != null && !this.dnsNames.isEmpty();
    }

    @Override
    public A addNewDnsName(String arg0) {
        return this.addToDnsNames(new String(arg0));
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public A addToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpAddresses(Integer index, String item) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpAddresses(String ... items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpAddresses(Collection<String> items) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipAddresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpAddresses(String ... items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.ipAddresses == null) continue;
            this.ipAddresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    @Override
    public String getIpAddress(Integer index) {
        return this.ipAddresses.get(index);
    }

    @Override
    public String getFirstIpAddress() {
        return this.ipAddresses.get(0);
    }

    @Override
    public String getLastIpAddress() {
        return this.ipAddresses.get(this.ipAddresses.size() - 1);
    }

    @Override
    public String getMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIpAddress(Predicate<String> predicate) {
        for (String item : this.ipAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIpAddresses(List<String> ipAddresses) {
        if (ipAddresses != null) {
            this.ipAddresses = new ArrayList<String>();
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        } else {
            this.ipAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses != null) {
            this.ipAddresses.clear();
        }
        if (ipAddresses != null) {
            for (String item : ipAddresses) {
                this.addToIpAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpAddresses() {
        return this.ipAddresses != null && !this.ipAddresses.isEmpty();
    }

    @Override
    public A addNewIpAddress(String arg0) {
        return this.addToIpAddresses(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    @Override
    public OrderSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public OrderSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public OrderSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    public A addToRequest(Integer index, Integer item) {
        if (this.request == null) {
            this.request = new ArrayList<Integer>();
        }
        this.request.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequest(Integer index, Integer item) {
        if (this.request == null) {
            this.request = new ArrayList<Integer>();
        }
        this.request.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequest(Integer ... items) {
        if (this.request == null) {
            this.request = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequest(Collection<Integer> items) {
        if (this.request == null) {
            this.request = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.request.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequest(Integer ... items) {
        for (Integer item : items) {
            if (this.request == null) continue;
            this.request.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequest(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.request == null) continue;
            this.request.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getRequest() {
        return this.request;
    }

    @Override
    public Integer getRequest(Integer index) {
        return this.request.get(index);
    }

    @Override
    public Integer getFirstRequest() {
        return this.request.get(0);
    }

    @Override
    public Integer getLastRequest() {
        return this.request.get(this.request.size() - 1);
    }

    @Override
    public Integer getMatchingRequest(Predicate<Integer> predicate) {
        for (Integer item : this.request) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRequest(Predicate<Integer> predicate) {
        for (Integer item : this.request) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRequest(List<Integer> request) {
        if (request != null) {
            this.request = new ArrayList<Integer>();
            for (Integer item : request) {
                this.addToRequest(item);
            }
        } else {
            this.request = null;
        }
        return (A)this;
    }

    @Override
    public A withRequest(Integer ... request) {
        if (this.request != null) {
            this.request.clear();
        }
        if (request != null) {
            for (Integer item : request) {
                this.addToRequest(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderSpecFluentImpl that = (OrderSpecFluentImpl)o;
        if (this.commonName != null ? !this.commonName.equals(that.commonName) : that.commonName != null) {
            return false;
        }
        if (this.dnsNames != null ? !this.dnsNames.equals(that.dnsNames) : that.dnsNames != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals((Object)that.duration) : that.duration != null) {
            return false;
        }
        if (this.ipAddresses != null ? !this.ipAddresses.equals(that.ipAddresses) : that.ipAddresses != null) {
            return false;
        }
        if (this.issuerRef != null ? !this.issuerRef.equals(that.issuerRef) : that.issuerRef != null) {
            return false;
        }
        return !(this.request != null ? !this.request.equals(that.request) : that.request != null);
    }

    public int hashCode() {
        return Objects.hash(this.commonName, this.dnsNames, this.duration, this.ipAddresses, this.issuerRef, this.request, super.hashCode());
    }

    public class IssuerRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<OrderSpecFluent.IssuerRefNested<N>>
    implements OrderSpecFluent.IssuerRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OrderSpecFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

