/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.visitor;

import io.fabric8.crd.generator.utils.Types;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.model.AnnotationRef;
import io.sundr.model.ClassRef;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class AnnotatedPropertyPathDetector
extends TypedVisitor<TypeDefBuilder> {
    protected static final String DOT = ".";
    protected static final String STATUS = ".status.";
    private final String prefix;
    private final String annotationName;
    private final List<Property> parents;
    private final AtomicReference<String> reference;
    private final Deque<Runnable> toRun;

    public AnnotatedPropertyPathDetector(String prefix, String annotationName) {
        this(prefix, annotationName, new ArrayList<Property>(), new AtomicReference<String>(), new ArrayDeque<Runnable>());
    }

    public AnnotatedPropertyPathDetector(String prefix, String annotationName, List<Property> parents, AtomicReference<String> reference, Deque<Runnable> toRun) {
        this.prefix = prefix;
        this.annotationName = annotationName;
        this.parents = parents;
        this.reference = reference;
        this.toRun = toRun;
    }

    private static boolean excludePropertyProcessing(Property p) {
        for (AnnotationRef annotation : p.getAnnotations()) {
            if (!annotation.getClassRef().getFullyQualifiedName().equals("com.fasterxml.jackson.annotation.JsonIgnore")) continue;
            return true;
        }
        return false;
    }

    public void visit(TypeDefBuilder builder) {
        TypeDef type = builder.build();
        List properties = type.getProperties();
        this.visitProperties(properties);
    }

    private void visitProperties(List<Property> properties) {
        for (Property p : properties) {
            ClassRef classRef;
            TypeDef propertyType;
            if (this.parents.contains(p)) continue;
            ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
            boolean match = false;
            for (AnnotationRef annotation : p.getAnnotations()) {
                match = annotation.getClassRef().getName().equals(this.annotationName);
                if (!match) continue;
                newParents.add(p);
                this.reference.set(newParents.stream().map(Property::getName).collect(Collectors.joining(DOT, this.prefix, "")));
                return;
            }
            if (!(p.getTypeRef() instanceof ClassRef) || AnnotatedPropertyPathDetector.excludePropertyProcessing(p) || (propertyType = Types.typeDefFrom(classRef = (ClassRef)p.getTypeRef())).isEnum() || classRef.getPackageName().startsWith("java.")) continue;
            newParents.add(p);
            new TypeDefBuilder(propertyType).accept(new Visitor[]{new AnnotatedPropertyPathDetector(this.prefix, this.annotationName, newParents, this.reference, this.toRun)});
        }
        if (this.parents.isEmpty()) {
            while (!this.toRun.isEmpty() && this.reference.get() == null) {
                this.toRun.pop().run();
            }
        }
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.reference.get());
    }
}

