/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.config.RunVolumeConfiguration;
import io.fabric8.maven.docker.util.DockerPathUtil;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public class VolumeBindingUtil {
    private static final String DOT = ".";
    private static final String DOUBLE_DOT = "..";
    private static final String TILDE = "~";
    private static final String RUNTIME_SEP = System.getProperty("file.separator");
    private static final String WINDOWS_SEP = "\\";
    private static final String UNIX_SEP = "/";
    private static final Pattern WINDOWS_DRIVE_PATTERN = Pattern.compile("^[A-Za-z]:\\\\.*");

    public static String resolveRelativeVolumeBinding(File baseDir, String bindingString) {
        String localPath;
        String[] pathParts = bindingString.split(":");
        if (SystemUtils.IS_OS_WINDOWS && WINDOWS_DRIVE_PATTERN.matcher(bindingString).matches() && pathParts.length > 2) {
            String[] winPathParts = new String[pathParts.length - 1];
            winPathParts[0] = pathParts[0] + ":" + pathParts[1];
            for (int i = 1; i < winPathParts.length; ++i) {
                winPathParts[i] = pathParts[i + 1];
            }
            pathParts = winPathParts;
        }
        if (VolumeBindingUtil.isRelativePath(localPath = pathParts[0])) {
            File resolvedFile;
            if (VolumeBindingUtil.isUserHomeRelativePath(localPath)) {
                resolvedFile = DockerPathUtil.resolveAbsolutely(VolumeBindingUtil.prepareUserHomeRelativePath(localPath), EnvUtil.getUserHome());
            } else {
                if (!baseDir.isAbsolute()) {
                    throw new IllegalArgumentException("Base directory '" + baseDir + "' must be absolute.");
                }
                resolvedFile = DockerPathUtil.resolveAbsolutely(localPath, baseDir.getAbsolutePath());
            }
            try {
                localPath = resolvedFile.getCanonicalFile().getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to canonicalize '" + resolvedFile + "'");
            }
        }
        if (SystemUtils.IS_OS_WINDOWS && localPath.contains(DOUBLE_DOT)) {
            File resolvedFile = new File(localPath);
            try {
                localPath = resolvedFile.getCanonicalFile().getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to canonicalize '" + resolvedFile + "'");
            }
        }
        if (pathParts.length > 1) {
            pathParts[0] = localPath;
            return VolumeBindingUtil.join(":", pathParts);
        }
        return localPath;
    }

    public static void resolveRelativeVolumeBindings(File baseDir, RunVolumeConfiguration volumeConfiguration) {
        List<String> bindings = volumeConfiguration.getBind();
        if (bindings == null || bindings.isEmpty()) {
            return;
        }
        for (int i = 0; i < bindings.size(); ++i) {
            bindings.set(i, VolumeBindingUtil.resolveRelativeVolumeBinding(baseDir, bindings.get(i)));
        }
    }

    static boolean isRelativePath(String candidatePath) {
        if (candidatePath.startsWith(UNIX_SEP) || candidatePath.startsWith(WINDOWS_SEP) || WINDOWS_DRIVE_PATTERN.matcher(candidatePath).matches()) {
            return false;
        }
        if (candidatePath.startsWith(DOT + RUNTIME_SEP) || candidatePath.startsWith(DOUBLE_DOT + RUNTIME_SEP)) {
            return true;
        }
        if (candidatePath.contains(UNIX_SEP) || candidatePath.contains(WINDOWS_SEP)) {
            return true;
        }
        return VolumeBindingUtil.isUserHomeRelativePath(candidatePath);
    }

    static boolean isUserHomeRelativePath(String candidatePath) {
        return candidatePath.startsWith(TILDE);
    }

    private static String prepareUserHomeRelativePath(String userHomePath) {
        if (!VolumeBindingUtil.isUserHomeRelativePath(userHomePath)) {
            return userHomePath;
        }
        if (userHomePath.equals(TILDE)) {
            return "";
        }
        if (userHomePath.startsWith(TILDE + RUNTIME_SEP)) {
            return userHomePath.substring(2);
        }
        throw new IllegalArgumentException("'" + userHomePath + "' cannot be relativized, cannot resolve arbitrary user home paths.");
    }

    private static String join(String with, String ... components) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < components.length) {
            result.append(components[i++]);
            if (i >= components.length) continue;
            result.append(with);
        }
        return result.toString();
    }
}

