/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EditableContainer;
import io.fabric8.kubernetes.api.model.EditableContainerPort;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.maven.core.config.ResourceConfiguration;
import io.fabric8.maven.core.config.VolumeConfiguration;
import io.fabric8.maven.core.handler.Containers;
import io.fabric8.maven.core.handler.EnvVarHandler;
import io.fabric8.maven.core.handler.ProbeHandler;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.json.JSONArray;
import org.json.JSONObject;

class ContainerHandler {
    private final EnvVarHandler envVarHandler;
    private final ProbeHandler probeHandler;
    private final MavenProject project;

    public ContainerHandler(MavenProject project, EnvVarHandler envVarHandler, ProbeHandler probeHandler) {
        this.envVarHandler = envVarHandler;
        this.probeHandler = probeHandler;
        this.project = project;
    }

    List<Container> getContainers(ResourceConfiguration config, List<ImageConfiguration> images) {
        ArrayList<Container> ret = new ArrayList<Container>();
        for (ImageConfiguration imageConfig : images) {
            if (imageConfig.getBuildConfiguration() == null) continue;
            EditableContainer container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(Containers.getKubernetesContainerName(this.project, imageConfig))).withImage(imageConfig.getName())).withImagePullPolicy(this.getImagePullPolicy(config))).withEnv(this.envVarHandler.getEnvironmentVariables(config.getEnv()))).withSecurityContext(this.createSecurityContext(config))).withPorts(this.getContainerPorts(imageConfig))).withVolumeMounts(this.getVolumeMounts(config))).withLivenessProbe(this.probeHandler.getProbe(config.getLiveness()))).withReadinessProbe(this.probeHandler.getProbe(config.getReadiness()))).build();
            ret.add((Container)container);
        }
        return ret;
    }

    private String getImagePullPolicy(ResourceConfiguration config) {
        String pullPolicy = config.getImagePullPolicy();
        String version = this.project.getVersion();
        if (Strings.isNullOrBlank((String)pullPolicy) && version != null && version.endsWith("SNAPSHOT")) {
            return "PullAlways";
        }
        return pullPolicy;
    }

    private SecurityContext createSecurityContext(ResourceConfiguration config) {
        return ((SecurityContextBuilder)new SecurityContextBuilder().withPrivileged(Boolean.valueOf(config.isContainerPrivileged()))).build();
    }

    private List<VolumeMount> getVolumeMounts(ResourceConfiguration config) {
        List<VolumeConfiguration> volumeConfigs = config.getVolumes();
        ArrayList<VolumeMount> ret = new ArrayList<VolumeMount>();
        if (volumeConfigs != null) {
            for (VolumeConfiguration volumeConfig : volumeConfigs) {
                List<String> mounts = volumeConfig.getMounts();
                if (mounts == null) continue;
                for (String mount : mounts) {
                    ret.add((VolumeMount)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volumeConfig.getName())).withMountPath(mount)).withReadOnly(Boolean.valueOf(false))).build());
                }
            }
        }
        return ret;
    }

    private List<ContainerPort> getContainerPorts(ImageConfiguration imageConfig) {
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        List ports = buildConfig.getPorts();
        if (ports != null) {
            ArrayList<ContainerPort> ret = new ArrayList<ContainerPort>();
            PortMapping portMapping = new PortMapping(ports, this.project.getProperties());
            JSONArray portSpecs = portMapping.toJson();
            for (int i = 0; i < portSpecs.length(); ++i) {
                JSONObject portSpec = portSpecs.getJSONObject(i);
                ret.add((ContainerPort)this.extractContainerPort(portSpec));
            }
            return ret;
        }
        return null;
    }

    private EditableContainerPort extractContainerPort(JSONObject portSpec) {
        ContainerPortBuilder portBuilder = (ContainerPortBuilder)new ContainerPortBuilder().withContainerPort(Integer.valueOf(portSpec.getInt("containerPort")));
        if (portSpec.has("hostPort")) {
            portBuilder.withHostPort(Integer.valueOf(portSpec.getInt("hostPort")));
        }
        if (portSpec.has("protocol")) {
            portBuilder.withProtocol(portSpec.getString("protocol").toUpperCase());
        }
        if (portSpec.has("hostIP")) {
            portBuilder.withHostIP(portSpec.getString("hostIP"));
        }
        return portBuilder.build();
    }
}

