/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.AnnotationConfiguration;
import io.fabric8.maven.core.config.MetricsConfig;
import io.fabric8.maven.core.config.ProbeConfiguration;
import io.fabric8.maven.core.config.ServiceConfiguration;
import io.fabric8.maven.core.config.VolumeConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class ResourceConfiguration {
    @Parameter
    private Map<String, String> env;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private AnnotationConfiguration annotations;
    @Parameter
    private List<VolumeConfiguration> volumes;
    @Parameter(defaultValue="${project.artifactId}")
    private String replicaSetName;
    @Parameter
    private List<ServiceConfiguration> services;
    @Parameter
    private ProbeConfiguration liveness;
    @Parameter
    private ProbeConfiguration readiness;
    @Parameter
    private MetricsConfig metrics;
    @Parameter
    private boolean containerPrivileged = false;
    @Parameter
    private String imagePullPolicy;
    @Parameter
    private Map<String, Integer> ports;
    @Parameter
    private int replicas = 1;
    @Parameter
    private String serviceAccount;
    @Parameter
    private String namespace;

    public Map<String, String> getEnv() {
        return this.env != null ? this.env : Collections.emptyMap();
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public AnnotationConfiguration getAnnotations() {
        return this.annotations != null ? this.annotations : new AnnotationConfiguration();
    }

    public List<VolumeConfiguration> getVolumes() {
        return this.volumes;
    }

    public List<ServiceConfiguration> getServices() {
        return this.services;
    }

    public ProbeConfiguration getLiveness() {
        return this.liveness;
    }

    public ProbeConfiguration getReadiness() {
        return this.readiness;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static class Builder {
        private ResourceConfiguration config = new ResourceConfiguration();

        public Builder replicaSetName(String name) {
            this.config.replicaSetName = name;
            return this;
        }

        public Builder imagePullPolicy(String policy) {
            this.config.imagePullPolicy = policy;
            return this;
        }

        public ResourceConfiguration build() {
            return this.config;
        }
    }
}

