/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=GoalFinder.class, instantiationStrategy="per-lookup")
public class GoalFinder {
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement(hint="default")
    private LifecycleMappingDelegate standardDelegate;
    @Requirement
    private Map<String, LifecycleMappingDelegate> delegates;

    public boolean runningWithGoal(MavenProject project, MavenSession session, String goal) throws MojoExecutionException {
        for (String goalOrPhase : session.getGoals()) {
            if (!(!goalOrPhase.contains(":") ? this.checkGoalInPhase(project, session, goal, goalOrPhase) : goal.equals(goalOrPhase))) continue;
            return true;
        }
        return false;
    }

    private boolean checkGoalInPhase(MavenProject project, MavenSession session, String goal, String phase) throws MojoExecutionException {
        Lifecycle lifecycle = this.defaultLifeCycles.get(phase);
        if (lifecycle == null) {
            throw new MojoExecutionException("Cannot find lifecycle phase " + phase);
        }
        LifecycleMappingDelegate delegate = this.findDelegate(lifecycle);
        try {
            Map executionsMap = delegate.calculateLifecycleMappings(session, project, lifecycle, phase);
            boolean foundPhase = false;
            boolean foundGoal = false;
            for (String p : lifecycle.getPhases()) {
                List executions = (List)executionsMap.get(p);
                if (executions != null) {
                    for (MojoExecution execution : executions) {
                        MojoDescriptor desc = execution.getMojoDescriptor();
                        if (desc == null || !desc.getFullGoalName().equals(goal)) continue;
                        foundGoal = true;
                        break;
                    }
                }
                if (!phase.equals(p)) continue;
                foundPhase = true;
                break;
            }
            return foundPhase && foundGoal;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Interna: Cannot extract executions", e);
        }
    }

    private LifecycleMappingDelegate findDelegate(Lifecycle lifecycle) {
        LifecycleMappingDelegate delegate;
        String lifecycleId = lifecycle.getId();
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycleId) >= 0) {
            delegate = this.standardDelegate;
        } else {
            delegate = this.delegates.get(lifecycleId);
            if (delegate == null) {
                delegate = this.standardDelegate;
            }
        }
        return delegate;
    }
}

