/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public final class PluginServiceFactory<C> {
    private C context;
    private static Pattern COMMENT_LINE_PATTERN = Pattern.compile("^(\\s*#.*|\\s*)$");

    public PluginServiceFactory(C context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> createServiceObjects(String ... descriptorPaths) {
        try {
            ServiceEntry.initDefaultOrder();
            TreeMap serviceMap = new TreeMap();
            for (String descriptor : descriptorPaths) {
                this.readServiceDefinitions(serviceMap, descriptor);
            }
            ArrayList ret = new ArrayList();
            for (Object service : serviceMap.values()) {
                ret.add(service);
            }
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            ServiceEntry.removeDefaultOrder();
        }
    }

    private <T> void readServiceDefinitions(Map<ServiceEntry, T> extractorMap, String defPath) {
        try {
            for (String url : PluginServiceFactory.getResources(defPath)) {
                this.readServiceDefinitionFromUrl(extractorMap, url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load service from " + defPath + ": " + e, e);
        }
    }

    public static Set<String> getResources(String resource) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        for (ClassLoader cl : PluginServiceFactory.getClassLoaders()) {
            Enumeration<URL> urlEnum = cl.getResources(resource);
            ret.addAll(PluginServiceFactory.extractUrlAsStringsFromEnumeration(urlEnum));
        }
        return ret;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), PluginServiceFactory.class.getClassLoader()};
    }

    private static Set<String> extractUrlAsStringsFromEnumeration(Enumeration<URL> urlEnum) {
        HashSet<String> ret = new HashSet<String>();
        while (urlEnum.hasMoreElements()) {
            ret.add(urlEnum.nextElement().toExternalForm());
        }
        return ret;
    }

    private <T> void readServiceDefinitionFromUrl(Map<ServiceEntry, T> extractorMap, String url) {
        String line = null;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(new URL(url).openStream(), "UTF8"));){
            line = reader.readLine();
            while (line != null) {
                this.createOrRemoveService(extractorMap, line);
                line = reader.readLine();
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalStateException("Cannot load service " + line + " defined in " + url + " : " + e + ". Aborting", e);
        }
    }

    private synchronized <T> void createOrRemoveService(Map<ServiceEntry, T> serviceMap, String line) throws ReflectiveOperationException {
        if (line.length() > 0 && !COMMENT_LINE_PATTERN.matcher(line).matches()) {
            ServiceEntry entry = new ServiceEntry(line);
            if (entry.isRemove()) {
                HashSet<ServiceEntry> toRemove = new HashSet<ServiceEntry>();
                for (ServiceEntry key : serviceMap.keySet()) {
                    if (!key.getClassName().equals(entry.getClassName())) continue;
                    toRemove.add(key);
                }
                for (ServiceEntry key : toRemove) {
                    serviceMap.remove(key);
                }
            } else {
                Class<T> clazz = PluginServiceFactory.classForName(entry.getClassName());
                if (clazz == null) {
                    throw new ClassNotFoundException("Class " + entry.getClassName() + " could not be found");
                }
                Constructor<T> constructor = clazz.getConstructor(this.context.getClass());
                if (constructor == null) {
                    throw new IllegalArgumentException("Internal Error: " + clazz + " does not have constructor (" + this.context.getClass() + ")");
                }
                T service = constructor.newInstance(this.context);
                serviceMap.put(entry, service);
            }
        }
    }

    public static <T> Class<T> classForName(String className) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        ClassLoader[] classLoaderArray = PluginServiceFactory.getClassLoaders();
        int n = classLoaderArray.length;
        for (int i = 0; i < n; ++i) {
            for (ClassLoader loader = classLoaderArray[i]; loader != null; loader = loader.getParent()) {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(className, true, loader);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                tried.add(loader);
            }
        }
        return null;
    }

    static class ServiceEntry
    implements Comparable<ServiceEntry> {
        private String className;
        private boolean remove;
        private Integer order;
        private static ThreadLocal<Integer> defaultOrderHolder = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 100;
            }
        };

        public ServiceEntry(String line) {
            String[] parts = line.split(",");
            if (parts[0].startsWith("!")) {
                this.remove = true;
                this.className = parts[0].substring(1);
            } else {
                this.remove = false;
                this.className = parts[0];
            }
            if (parts.length > 1) {
                try {
                    this.order = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException exp) {
                    this.order = this.nextDefaultOrder();
                }
            } else {
                this.order = this.nextDefaultOrder();
            }
        }

        private Integer nextDefaultOrder() {
            Integer defaultOrder = defaultOrderHolder.get();
            defaultOrderHolder.set(defaultOrder + 1);
            return defaultOrder;
        }

        private static void initDefaultOrder() {
            defaultOrderHolder.set(100);
        }

        private static void removeDefaultOrder() {
            defaultOrderHolder.remove();
        }

        private String getClassName() {
            return this.className;
        }

        private boolean isRemove() {
            return this.remove;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceEntry that = (ServiceEntry)o;
            return this.className.equals(that.className);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public int compareTo(ServiceEntry o) {
            return this.order - o.order;
        }
    }
}

