/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.access;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Strings;
import java.net.UnknownHostException;

public class ClusterAccess {
    private String namespace;

    public ClusterAccess(String namespace) {
        this.namespace = namespace;
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = KubernetesHelper.defaultNamespace();
        }
        if (Strings.isNullOrBlank((String)this.namespace)) {
            this.namespace = "default";
        }
    }

    public KubernetesClient createKubernetesClient() {
        return new DefaultKubernetesClient(this.createDefaultConfig());
    }

    public OpenShiftClient createOpenShiftClient() {
        return new DefaultOpenShiftClient(this.createDefaultConfig());
    }

    private Config createDefaultConfig() {
        return ((ConfigBuilder)new ConfigBuilder().withNamespace(this.getNamespace())).build();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isOpenShift(Logger log) {
        try {
            return KubernetesHelper.isOpenShift((KubernetesClient)this.createKubernetesClient());
        }
        catch (KubernetesClientException exp) {
            Throwable cause = exp.getCause();
            String prefix = cause instanceof UnknownHostException ? "Unknown host " : "";
            log.warn("Cannot access cluster for detecting mode: %s%s", new Object[]{prefix, cause != null ? cause.getMessage() : exp.getMessage()});
            return false;
        }
    }

    public PlatformMode resolvePlatformMode(PlatformMode mode, Logger log) {
        if (mode == null) {
            mode = PlatformMode.DEFAULT;
        }
        PlatformMode resolvedMode = mode.isAuto() ? (this.isOpenShift(log) ? PlatformMode.openshift : PlatformMode.kubernetes) : mode;
        log.info("Running in %s mode", new Object[]{resolvedMode.getLabel()});
        return resolvedMode;
    }
}

