/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import io.fabric8.maven.core.config.MetaDataConfig;
import io.fabric8.maven.core.config.MetricsConfig;
import io.fabric8.maven.core.config.ProbeConfig;
import io.fabric8.maven.core.config.ServiceConfig;
import io.fabric8.maven.core.config.VolumeConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class ResourceConfig {
    @Parameter
    private Map<String, String> env;
    @Parameter
    private MetaDataConfig labels = new MetaDataConfig();
    @Parameter
    private MetaDataConfig annotations = new MetaDataConfig();
    @Parameter
    private List<VolumeConfig> volumes;
    @Parameter(defaultValue="${project.artifactId}")
    private String controllerName;
    @Parameter
    private List<ServiceConfig> services;
    @Parameter
    private ProbeConfig liveness;
    @Parameter
    private ProbeConfig readiness;
    @Parameter
    private MetricsConfig metrics;
    @Parameter
    private boolean containerPrivileged = false;
    @Parameter
    private String imagePullPolicy;
    @Parameter
    private Map<String, Integer> ports;
    @Parameter
    private int replicas = 1;
    @Parameter
    private String serviceAccount;
    @Parameter
    private String namespace;

    public Map<String, String> getEnv() {
        return this.env != null ? this.env : Collections.emptyMap();
    }

    public MetaDataConfig getLabels() {
        return this.labels;
    }

    public MetaDataConfig getAnnotations() {
        return this.annotations;
    }

    public List<VolumeConfig> getVolumes() {
        return this.volumes;
    }

    public List<ServiceConfig> getServices() {
        return this.services;
    }

    public ProbeConfig getLiveness() {
        return this.liveness;
    }

    public ProbeConfig getReadiness() {
        return this.readiness;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public Map<String, Integer> getPorts() {
        return this.ports;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static class Builder {
        private ResourceConfig config = new ResourceConfig();

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder controllerName(String name) {
            this.config.controllerName = name;
            return this;
        }

        public Builder imagePullPolicy(String policy) {
            this.config.imagePullPolicy = policy;
            return this;
        }

        public Builder withReplicas(int replicas) {
            this.config.replicas = replicas;
            return this;
        }

        public ResourceConfig build() {
            return this.config;
        }
    }
}

