/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.docker.config.ImageConfiguration;
import java.util.List;

public class DaemonSetHandler {
    private final PodTemplateHandler podTemplateHandler;

    DaemonSetHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public DaemonSet getDaemonSet(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DaemonSetBuilder)((DaemonSetBuilder)new DaemonSetBuilder().withMetadata(this.createDaemonSetMetaData(config))).withSpec(this.createDaemonSetSpec(config, images))).build();
    }

    private ObjectMeta createDaemonSetMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId((String)config.getControllerName(), (String)"controller name"))).build();
    }

    private DaemonSetSpec createDaemonSetSpec(ResourceConfig config, List<ImageConfiguration> images) {
        return ((DaemonSetSpecBuilder)new DaemonSetSpecBuilder().withTemplate(this.podTemplateHandler.getPodTemplate(config, images))).build();
    }
}

