/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.maven.enricher.api.AbstractHealthCheckEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class KarafHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final int DEFAULT_HEALTH_CHECK_PORT = 8181;

    public KarafHealthCheckEnricher(EnricherContext buildContext) {
        super(buildContext, "karaf-health-check");
    }

    protected Probe getReadinessProbe() {
        Probe probe = this.discoverKarafProbe("/readiness-check", 10);
        return probe;
    }

    protected Probe getLivenessProbe() {
        Probe probe = this.discoverKarafProbe("/health-check", 180);
        return probe;
    }

    private Probe discoverKarafProbe(String path, int initialDelay) {
        for (Plugin plugin : this.getProject().getBuildPlugins()) {
            if (!"karaf-maven-plugin".equals(plugin.getArtifactId())) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration == null) {
                return null;
            }
            Xpp3Dom startupFeatures = configuration.getChild("startupFeatures");
            if (startupFeatures == null) {
                return null;
            }
            for (Xpp3Dom feature : startupFeatures.getChildren("feature")) {
                if (!"fabric8-karaf-checks".equals(feature.getValue())) continue;
                return ((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(Integer.valueOf(8181))).withPath(path)).endHttpGet()).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
            }
        }
        return null;
    }
}

