/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.maven.enricher.api.util.InitContainerHandler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class AutoTLSEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-autotls";
    static final String AUTOTLS_ANNOTATION_KEY = "service.alpha.openshift.io/serving-cert-secret-name";
    private String secretName = this.getConfig(Config.tlsSecretName, this.getProject().getArtifactId() + "-tls");
    private final InitContainerHandler initContainerHandler;

    public AutoTLSEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
        this.initContainerHandler = new InitContainerHandler(buildContext.getLog());
    }

    public Map<String, String> getAnnotations(Kind kind) {
        if (!this.isOpenShiftMode() || kind != Kind.SERVICE) {
            return null;
        }
        return Collections.singletonMap(AUTOTLS_ANNOTATION_KEY, this.secretName);
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        if (!this.isOpenShiftMode()) {
            return;
        }
        builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

            public void visit(PodSpecBuilder builder) {
                String tlsSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName);
                if (!this.isVolumeAlreadyExists(builder.buildVolumes(), tlsSecretVolumeName)) {
                    ((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)builder.addNewVolume().withName(tlsSecretVolumeName)).withNewSecret().withSecretName(AutoTLSEnricher.this.secretName)).endSecret()).endVolume();
                }
                String jksSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.jksVolumeName);
                if (!this.isVolumeAlreadyExists(builder.buildVolumes(), jksSecretVolumeName)) {
                    ((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)builder.addNewVolume().withName(jksSecretVolumeName)).withNewEmptyDir("Memory")).endVolume();
                }
            }

            private boolean isVolumeAlreadyExists(List<Volume> volumes, String volumeName) {
                for (Volume v : volumes) {
                    if (!volumeName.equals(v.getName())) continue;
                    return true;
                }
                return false;
            }
        });
        builder.accept((Visitor)new TypedVisitor<ContainerBuilder>(){

            public void visit(ContainerBuilder builder) {
                String tlsSecretVolumeName = AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName);
                if (!this.isVolumeMountAlreadyExists(builder.buildVolumeMounts(), tlsSecretVolumeName)) {
                    ((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)builder.addNewVolumeMount().withName(tlsSecretVolumeName)).withMountPath(AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeMountPoint))).withReadOnly(Boolean.valueOf(true))).endVolumeMount();
                }
                String jksVolumeName = AutoTLSEnricher.this.getConfig(Config.jksVolumeName);
                if (!this.isVolumeMountAlreadyExists(builder.buildVolumeMounts(), jksVolumeName)) {
                    ((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)builder.addNewVolumeMount().withName(jksVolumeName)).withMountPath(AutoTLSEnricher.this.getConfig(Config.jksVolumeMountPoint))).withReadOnly(Boolean.valueOf(true))).endVolumeMount();
                }
            }

            private boolean isVolumeMountAlreadyExists(List<VolumeMount> volumes, String volumeName) {
                for (VolumeMount v : volumes) {
                    if (!volumeName.equals(v.getName())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public void adapt(KubernetesListBuilder builder) {
        if (!this.isOpenShiftMode()) {
            return;
        }
        builder.accept((Visitor)new TypedVisitor<PodTemplateSpecBuilder>(){

            public void visit(PodTemplateSpecBuilder builder) {
                AutoTLSEnricher.this.initContainerHandler.appendInitContainer(builder, this.createInitContainer());
            }

            private JSONObject createInitContainer() {
                JSONObject entry = new JSONObject();
                entry.put("name", (Object)AutoTLSEnricher.this.getConfig(Config.pemToJKSInitContainerName));
                entry.put("image", (Object)AutoTLSEnricher.this.getConfig(Config.pemToJKSInitContainerImage));
                entry.put("imagePullPolicy", (Object)"IfNotPresent");
                entry.put("args", (Object)this.createArgsArray());
                entry.put("volumeMounts", (Object)this.createMounts());
                return entry;
            }

            private JSONArray createArgsArray() {
                JSONArray ret = new JSONArray();
                ret.put((Object)"-cert-file");
                ret.put((Object)(AutoTLSEnricher.this.getConfig(Config.keystoreCertAlias) + "=/tls-pem/tls.crt"));
                ret.put((Object)"-key-file");
                ret.put((Object)(AutoTLSEnricher.this.getConfig(Config.keystoreCertAlias) + "=/tls-pem/tls.key"));
                ret.put((Object)"-keystore");
                ret.put((Object)("/tls-jks/" + AutoTLSEnricher.this.getConfig(Config.keystoreFileName)));
                ret.put((Object)"-keystore-password");
                ret.put((Object)AutoTLSEnricher.this.getConfig(Config.keystorePassword));
                return ret;
            }

            private JSONArray createMounts() {
                JSONObject pemMountPoint = new JSONObject();
                pemMountPoint.put("name", (Object)AutoTLSEnricher.this.getConfig(Config.tlsSecretVolumeName));
                pemMountPoint.put("mountPath", (Object)"/tls-pem");
                JSONObject jksMountPoint = new JSONObject();
                jksMountPoint.put("name", (Object)AutoTLSEnricher.this.getConfig(Config.jksVolumeName));
                jksMountPoint.put("mountPath", (Object)"/tls-jks");
                JSONArray ret = new JSONArray();
                ret.put((Object)pemMountPoint);
                ret.put((Object)jksMountPoint);
                return ret;
            }
        });
    }

    static enum Config implements Configs.Key
    {
        tlsSecretName,
        tlsSecretVolumeMountPoint{
            {
                this.d = "/var/run/secrets/fabric8.io/tls-pem";
            }
        }
        ,
        tlsSecretVolumeName{
            {
                this.d = "tls-pem";
            }
        }
        ,
        jksVolumeMountPoint{
            {
                this.d = "/var/run/secrets/fabric8.io/tls-jks";
            }
        }
        ,
        jksVolumeName{
            {
                this.d = "tls-jks";
            }
        }
        ,
        pemToJKSInitContainerImage{
            {
                this.d = "jimmidyson/pemtokeystore:v0.1.0";
            }
        }
        ,
        pemToJKSInitContainerName{
            {
                this.d = "tls-jks-converter";
            }
        }
        ,
        keystoreFileName{
            {
                this.d = "keystore.jks";
            }
        }
        ,
        keystorePassword{
            {
                this.d = "changeit";
            }
        }
        ,
        keystoreCertAlias{
            {
                this.d = "server";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

