/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.ProjectConfig;
import io.fabric8.devops.ProjectConfigs;
import io.fabric8.devops.ProjectRepositories;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.maven.Zips;
import io.fabric8.maven.support.JsonSchema;
import io.fabric8.maven.support.JsonSchemas;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Function;
import io.fabric8.utils.GitHelpers;
import io.fabric8.utils.Objects;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import io.fabric8.utils.URLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public abstract class AbstractFabric8Mojo
extends AbstractNamespacedMojo {
    private static final String DEFAULT_CONFIG_FILE_NAME = "kubernetes.json";
    public static String[] ICON_EXTENSIONS = new String[]{".svg", ".png", ".gif", ".jpg", ".jpeg"};
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.zip.file", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-app.zip")
    protected File zipFile;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.source.dir", defaultValue="${basedir}/src/main/fabric8")
    protected File appConfigDir;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.iconRef")
    protected String iconRef;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.json.target", defaultValue="${basedir}/target/classes/kubernetes.json")
    private File kubernetesJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.json.source", defaultValue="${basedir}/src/main/fabric8/kubernetes.json")
    protected File kubernetesSourceJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.combineDependencies", defaultValue="false")
    protected boolean combineDependencies;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.combineJson.target")
    private File kubernetesCombineJson;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.pureKubernetes", defaultValue="false")
    protected boolean pureKubernetes;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.replicas", defaultValue="1")
    private Integer replicas;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.envProperties", defaultValue="${basedir}/src/main/fabric8/env.properties")
    protected File envPropertiesFile;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.environmentVariableToAnnotationsFile", defaultValue="${basedir}/src/main/fabric8/environemntToAnnotations.properties")
    protected File environmentVariableToAnnotationsFile;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.excludedFiles", defaultValue="io.fabric8.agent.properties")
    private String[] filesToBeExcluded;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.cd.build", defaultValue="false")
    private boolean cdBuild;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.cd.envVar", defaultValue="JENKINS_HOME")
    private String cdEnvVarName;
    @org.apache.maven.plugins.annotations.Parameter(property="docker.image")
    private String dockerImage;
    @org.apache.maven.plugins.annotations.Parameter(property="fabric8.extended.environment.metadata", defaultValue="true")
    private Boolean extendedMetadata;

    protected static File copyReadMe(File src, File appBuildDir) throws IOException {
        return AbstractFabric8Mojo.copyReadMe(src, appBuildDir, null);
    }

    protected static File copyReadMe(File src, File appBuildDir, String outputFileName) throws IOException {
        File[] files = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        });
        if (files != null && files.length == 1) {
            File readme = files[0];
            if (Strings.isNullOrBlank((String)outputFileName)) {
                outputFileName = readme.getName();
            }
            File outFile = new File(appBuildDir, outputFileName);
            Files.copy((File)readme, (File)outFile);
            return outFile;
        }
        return null;
    }

    protected static Object loadJsonFile(File file) throws MojoExecutionException {
        try {
            return KubernetesHelper.loadJson((File)file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to parse JSON " + file + ". " + e, (Exception)e);
        }
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    protected static URLClassLoader createURLClassLoader(Collection<URL> jars) {
        return new URLClassLoader(jars.toArray(new URL[jars.size()]));
    }

    public File getKubernetesJson() {
        return this.kubernetesJson;
    }

    public File getKubernetesCombineJson() {
        return this.kubernetesCombineJson;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    protected boolean isPom(MavenProject reactorProject) {
        return "pom".equals(reactorProject.getPackaging());
    }

    protected InputStream loadPluginResource(String iconRef) throws MojoExecutionException {
        InputStream answer = Thread.currentThread().getContextClassLoader().getResourceAsStream(iconRef);
        if (answer == null) {
            answer = this.getTestClassLoader().getResourceAsStream(iconRef);
        }
        if (answer == null) {
            answer = ((Object)((Object)this)).getClass().getResourceAsStream(iconRef);
        }
        return answer;
    }

    protected URLClassLoader getCompileClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getCompileClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader getTestClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.getProject().getTestClasspathElements();
            return this.createClassLoader(classpathElements, this.getProject().getBuild().getTestOutputDirectory());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
    }

    protected URLClassLoader createClassLoader(List<String> classpathElements, String ... paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        for (Object e : classpathElements) {
            if (e == null) continue;
            String path = e.toString();
            URL url = this.pathToUrl(path);
            urls.add(url);
        }
        this.getLog().debug((CharSequence)("Creating class loader from: " + urls));
        return AbstractFabric8Mojo.createURLClassLoader(urls);
    }

    private URL pathToUrl(String path) throws MalformedURLException {
        File file = new File(path);
        return file.toURI().toURL();
    }

    protected boolean hasConfigDir() {
        return this.appConfigDir.isDirectory();
    }

    protected boolean isPomProject() {
        return this.isPom(this.getProject());
    }

    protected void addEnvironmentAnnotations(File json) throws MojoExecutionException {
        try {
            Object dto = AbstractFabric8Mojo.loadJsonFile(json);
            if (dto instanceof KubernetesList) {
                KubernetesList container = (KubernetesList)dto;
                List items = container.getItems();
                this.addEnvironmentAnnotations(items);
                this.getLog().info((CharSequence)"Added environment annotations:");
                this.printSummary(items);
                container.setItems(items);
                KubernetesHelper.saveJson((File)json, (Object)container);
            } else if (dto instanceof Template) {
                Template container = (Template)dto;
                List items = container.getObjects();
                this.addEnvironmentAnnotations(items);
                this.getLog().info((CharSequence)"Added environment annotations:");
                this.printSummary(items);
                container.setObjects(items);
                this.getLog().info((CharSequence)"Template is now:");
                this.printSummary(container.getObjects());
                KubernetesHelper.saveJson((File)json, (Object)container);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to updated JSON file " + json + ". " + e, (Exception)e);
        }
    }

    protected void addEnvironmentAnnotations(Iterable<HasMetadata> items) throws MojoExecutionException {
        if (items != null) {
            for (HasMetadata item : items) {
                if (item instanceof KubernetesList) {
                    KubernetesList list = (KubernetesList)item;
                    this.addEnvironmentAnnotations(list.getItems());
                    continue;
                }
                if (item instanceof Template) {
                    Template template = (Template)item;
                    this.addEnvironmentAnnotations(template.getObjects());
                    continue;
                }
                if (item instanceof ReplicationController) {
                    this.addEnvironmentAnnotations(item);
                    continue;
                }
                if (!(item instanceof DeploymentConfig)) continue;
                this.addEnvironmentAnnotations(item);
            }
        }
    }

    protected void addEnvironmentAnnotations(HasMetadata resource) throws MojoExecutionException {
        HashMap<String, String> mapEnvVarToAnnotation = new HashMap<String, String>();
        String resourceName = "environmentAnnotations.properties";
        URL url = ((Object)((Object)this)).getClass().getResource(resourceName);
        if (url == null) {
            throw new MojoExecutionException("Cannot find resource `" + resourceName + "` on the classpath!");
        }
        AbstractFabric8Mojo.addPropertiesFileToMap(url, mapEnvVarToAnnotation);
        AbstractFabric8Mojo.addPropertiesFileToMap(this.environmentVariableToAnnotationsFile, mapEnvVarToAnnotation);
        Map annotations = KubernetesHelper.getOrCreateAnnotations((HasMetadata)resource);
        Set entries = mapEnvVarToAnnotation.entrySet();
        for (Map.Entry entry : entries) {
            String envVar = (String)entry.getKey();
            String annotation = (String)entry.getValue();
            if (!Strings.isNotBlank((String)envVar) || !Strings.isNotBlank((String)annotation)) continue;
            String value = Systems.getEnvVarOrSystemProperty((String)envVar);
            if (Strings.isNullOrBlank((String)value)) {
                value = this.tryDefaultAnnotationEnvVar(envVar);
            }
            if (!Strings.isNotBlank((String)value)) continue;
            String oldValue = (String)annotations.get(annotation);
            if (Strings.isNotBlank((String)oldValue)) {
                this.getLog().debug((CharSequence)("Not adding annotation `" + annotation + "` to " + KubernetesHelper.getKind((HasMetadata)resource) + " " + KubernetesHelper.getName((HasMetadata)resource) + " with value `" + value + "` as there is already an annotation value of `" + oldValue + "`"));
                continue;
            }
            annotations.put(annotation, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String tryDefaultAnnotationEnvVar(String envVarName) {
        if (this.extendedMetadata != null && !this.extendedMetadata.booleanValue()) {
            return null;
        }
        MavenProject rootProject = this.getRootProject();
        File basedir = rootProject.getBasedir();
        if (basedir == null) {
            basedir = this.getProject().getBasedir();
        }
        if (basedir == null) {
            basedir = new File(System.getProperty("basedir", "."));
        }
        ProjectConfig projectConfig = ProjectConfigs.loadFromFolder((File)basedir);
        String repoName = rootProject.getArtifactId();
        String userEnvVar = "JENKINS_GOGS_USER";
        String username = Systems.getEnvVarOrSystemProperty((String)userEnvVar);
        if (Objects.equal((Object)"BUILD_URL", (Object)envVarName)) {
            String jobUrl = projectConfig.getLink("Job");
            if (Strings.isNullOrBlank((String)jobUrl)) {
                String name = projectConfig.getBuildName();
                if (Strings.isNullOrBlank((String)name) && Strings.isNotBlank((String)repoName)) {
                    name = repoName;
                    if (Strings.isNotBlank((String)username)) {
                        name = ProjectRepositories.createBuildName((String)username, (String)repoName);
                    } else {
                        this.warnIfInCDBuild("Cannot auto-default BUILD_URL as there is no environment variable `" + userEnvVar + "` defined so we can't guess the Jenkins build URL");
                    }
                }
                if (Strings.isNotBlank((String)name)) {
                    try {
                        String jenkinsUrl = KubernetesHelper.getServiceURLInCurrentNamespace((KubernetesClient)this.getKubernetes(), (String)"jenkins", (String)"http", null, (boolean)true);
                        jobUrl = URLUtils.pathJoin((String[])new String[]{jenkinsUrl, "/job", name});
                    }
                    catch (Throwable e) {
                        Throwable cause = e;
                        boolean notFound = false;
                        boolean connectError = false;
                        Iterable<Throwable> it = AbstractFabric8Mojo.createExceptionIterable(e);
                        for (Throwable t : it) {
                            connectError = t instanceof ConnectException || "No route to host".equals(t.getMessage());
                            boolean bl = notFound = t instanceof IllegalArgumentException || t.getMessage() != null && t.getMessage().startsWith("No kubernetes service could be found for name");
                            if (!connectError && !notFound) continue;
                            cause = t;
                            break;
                        }
                        if (connectError) {
                            this.warnIfInCDBuild("Cannot connect to Kubernetes to find jenkins service URL: " + cause.getMessage());
                        }
                        if (notFound) {
                            this.warnIfInCDBuild(cause.getMessage());
                        }
                        this.warnIfInCDBuild("Cannot find jenkins service URL: " + cause, cause);
                    }
                }
            }
            if (Strings.isNotBlank((String)jobUrl)) {
                String buildId = Systems.getEnvVarOrSystemProperty((String)"BUILD_ID");
                if (Strings.isNotBlank((String)buildId)) {
                    jobUrl = URLUtils.pathJoin((String[])new String[]{jobUrl, buildId});
                } else {
                    this.warnIfInCDBuild("Cannot find BUILD_ID to create a specific jenkins build URL. So using: " + jobUrl);
                }
            }
            return jobUrl;
        }
        if (Objects.equal((Object)"GIT_URL", (Object)envVarName)) {
            if (Strings.isNotBlank((String)repoName) && Strings.isNotBlank((String)username)) {
                try {
                    String gogsUrl = KubernetesHelper.getServiceURLInCurrentNamespace((KubernetesClient)this.getKubernetes(), (String)"gogs", (String)"http", null, (boolean)true);
                    String rootGitUrl = URLUtils.pathJoin((String[])new String[]{gogsUrl, username, repoName});
                    String gitCommitId = this.getGitCommitId(envVarName, basedir);
                    if (Strings.isNotBlank((String)gitCommitId)) {
                        rootGitUrl = URLUtils.pathJoin((String[])new String[]{rootGitUrl, "commit", gitCommitId});
                    }
                    return rootGitUrl;
                }
                catch (Throwable e) {
                    Throwable cause = e;
                    boolean notFound = false;
                    boolean connectError = false;
                    Iterable<Throwable> it = AbstractFabric8Mojo.createExceptionIterable(e);
                    for (Throwable t : it) {
                        notFound = t instanceof IllegalArgumentException || t.getMessage() != null && t.getMessage().startsWith("No kubernetes service could be found for name");
                        connectError = t instanceof ConnectException || "No route to host".equals(t.getMessage());
                        if (!connectError) continue;
                        cause = t;
                        break;
                    }
                    if (connectError) {
                        this.warnIfInCDBuild("Cannot connect to Kubernetes to find gogs service URL: " + cause.getMessage());
                    }
                    if (notFound) {
                        this.warnIfInCDBuild(cause.getMessage());
                    }
                    this.warnIfInCDBuild("Cannot find gogs service URL: " + cause, cause);
                }
            } else {
                this.warnIfInCDBuild("Cannot auto-default GIT_URL as there is no environment variable `" + userEnvVar + "` defined so we can't guess the Gogs build URL");
            }
        } else {
            if (Objects.equal((Object)"GIT_COMMIT", (Object)envVarName)) {
                return this.getGitCommitId(envVarName, basedir);
            }
            if (Objects.equal((Object)"GIT_BRANCH", (Object)envVarName)) {
                try (Repository repository = this.getGitRepository(basedir, envVarName);){
                    if (repository != null) {
                        String cause = repository.getBranch();
                        return cause;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getGitCommitId(String envVarName, File basedir) {
        Repository repository = this.getGitRepository(basedir, envVarName);
        try {
            if (repository != null) {
                this.getLog().info((CharSequence)("Looking at repo with directory " + repository.getDirectory()));
                Iterable logs = new Git(repository).log().call();
                Iterator iterator = logs.iterator();
                if (iterator.hasNext()) {
                    RevCommit rev = (RevCommit)iterator.next();
                    String string = rev.getName();
                    return string;
                }
                this.warnIfInCDBuild("Cannot default " + envVarName + " no commits could be found");
            } else {
                this.warnIfInCDBuild("Cannot default " + envVarName + " as no git repository could be found");
            }
        }
        catch (Exception e) {
            this.warnIfInCDBuild("Failed to find git commit id. " + e, e);
        }
        finally {
            if (repository != null) {
                try {
                    repository.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    protected void warnIfInCDBuild(String message) {
        if (this.isInCDBuild()) {
            this.getLog().warn((CharSequence)message);
        } else {
            this.getLog().debug((CharSequence)message);
        }
    }

    protected boolean isInCDBuild() {
        if (this.cdBuild) {
            return true;
        }
        String envVar = System.getenv(this.cdEnvVarName);
        return Strings.isNotBlank((String)envVar);
    }

    protected void warnIfInCDBuild(String message, Throwable exception) {
        if (this.isInCDBuild()) {
            this.getLog().warn((CharSequence)message, exception);
        } else {
            this.getLog().debug((CharSequence)message, exception);
        }
    }

    protected static Iterable<Throwable> createExceptionIterable(Throwable exception) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable current = exception; current != null; current = current.getCause()) {
            throwables.add(current);
        }
        Collections.reverse(throwables);
        return throwables;
    }

    protected Repository getGitRepository(File basedir, String envVarName) {
        try {
            File gitFolder = GitHelpers.findGitFolder((File)basedir);
            if (gitFolder == null) {
                this.warnIfInCDBuild("Could not find .git folder based on the current basedir of " + basedir);
                return null;
            }
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
            if (repository == null) {
                this.warnIfInCDBuild("Cannot create default value for $" + envVarName + " as no .git/config file could be found");
            }
            return repository;
        }
        catch (Exception e) {
            this.warnIfInCDBuild("Failed to initialise Git Repository: " + e, e);
            return null;
        }
    }

    protected boolean shouldGenerateForThisProject() {
        return !this.isPomProject() || this.hasConfigDir();
    }

    public Map<String, String> getEnvironmentVariableProperties() throws MojoExecutionException {
        Map rawProperties = PropertiesHelper.findPropertiesWithPrefix((Properties)this.getProject().getProperties(), (String)"fabric8.env.", (Function)Strings.toEnvironmentVariableFunction());
        Set entries = rawProperties.entrySet();
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = AbstractFabric8Mojo.unquoteTemplateExpression(value);
            answer.put(key, value);
        }
        AbstractFabric8Mojo.addPropertiesFileToMap(this.envPropertiesFile, answer);
        return answer;
    }

    protected static void addPropertiesFileToMap(File file, Map<String, String> answer) throws MojoExecutionException {
        if (file != null && file.isFile() && file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                Properties properties = new Properties();
                properties.load(in);
                Map map = PropertiesHelper.toMap((Properties)properties);
                answer.putAll(map);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load properties file: " + file + ". " + e, (Exception)e);
            }
        }
    }

    protected static void addPropertiesFileToMap(URL url, Map<String, String> answer) throws MojoExecutionException {
        if (url != null) {
            try (InputStream in = url.openStream();){
                Properties properties = new Properties();
                properties.load(in);
                Map map = PropertiesHelper.toMap((Properties)properties);
                answer.putAll(map);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to load properties URL: " + url + ". " + e, (Exception)e);
            }
        }
    }

    public static String unquoteTemplateExpression(String value) {
        return value;
    }

    public JsonSchema getEnvironmentVariableJsonSchema() throws IOException, MojoExecutionException {
        JsonSchema schema = JsonSchemas.loadEnvironmentSchemas(this.getCompileClassLoader(), this.getProject().getBuild().getOutputDirectory());
        if (schema == null) {
            this.getLog().debug((CharSequence)"No environment schemas found for file: io/fabric8/environment/schema.json");
            schema = new JsonSchema();
        }
        Map<String, String> envs = this.getEnvironmentVariableProperties();
        JsonSchemas.addEnvironmentVariables(schema, envs);
        return schema;
    }

    protected File copyIconToFolder(File appBuildDir) throws MojoExecutionException, IOException {
        File[] icons;
        if (Strings.isNotBlank((String)this.iconRef) && ((icons = appBuildDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name == null) {
                    return false;
                }
                String lower = name.toLowerCase();
                if (lower.startsWith("icon.")) {
                    for (String ext : ICON_EXTENSIONS) {
                        if (!lower.endsWith(ext)) continue;
                        return true;
                    }
                }
                return false;
            }
        })) == null || icons.length == 0)) {
            InputStream in = this.loadPluginResource(this.iconRef);
            if (in == null) {
                for (String ext : ICON_EXTENSIONS) {
                    String name = this.iconRef + ext;
                    in = this.loadPluginResource(name);
                    if (in == null) continue;
                    this.iconRef = name;
                    break;
                }
            }
            if (in != null) {
                String fileName = "icon." + Files.getFileExtension((String)this.iconRef);
                File outFile = new File(appBuildDir, fileName);
                Files.copy((InputStream)in, (OutputStream)new FileOutputStream(outFile));
                this.getLog().info((CharSequence)("Generated icon file " + outFile + " from icon reference: " + this.iconRef));
                return outFile;
            }
        }
        return null;
    }

    protected void copyAppConfigFiles(File appBuildDir, File appConfigDir) throws IOException {
        File[] files = appConfigDir.listFiles();
        if (files != null) {
            appBuildDir.mkdirs();
            for (File file : files) {
                if (this.toBeExclude(file.getName())) continue;
                File outFile = new File(appBuildDir, file.getName());
                if (file.isDirectory()) {
                    this.copyAppConfigFiles(outFile, file);
                    continue;
                }
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    protected boolean toBeExclude(String fileName) {
        List<String> excludedFilesList = Arrays.asList(this.filesToBeExcluded);
        Boolean result = excludedFilesList.contains(fileName);
        return result;
    }

    protected void copyReadMe(File appBuildDir) throws IOException {
        MavenProject project = this.getProject();
        AbstractFabric8Mojo.copyReadMe(project.getFile().getParentFile(), appBuildDir);
    }

    protected void copySummaryText(File appBuildDir) throws IOException {
        MavenProject project = this.getProject();
        String description = project.getDescription();
        if (Strings.isNotBlank((String)description)) {
            File summaryMd = new File(appBuildDir, "Summary.md");
            summaryMd.getParentFile().mkdirs();
            if (!summaryMd.exists()) {
                byte[] bytes = description.getBytes();
                Files.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)new FileOutputStream(summaryMd));
            }
        }
    }

    protected void printSummary(Object kubeResource) throws IOException {
        if (kubeResource instanceof Template) {
            Template template = (Template)kubeResource;
            String id = KubernetesHelper.getName((HasMetadata)template);
            this.getLog().info((CharSequence)("  Template " + id + " " + KubernetesHelper.summaryText((Template)template)));
            this.printSummary(template.getObjects());
            return;
        }
        List list = KubernetesHelper.toItemList((Object)kubeResource);
        for (Object object : list) {
            if (object == null) continue;
            if (object instanceof List) {
                this.printSummary(object);
                continue;
            }
            String kind = object.getClass().getSimpleName();
            String id = KubernetesHelper.getObjectId(object);
            this.getLog().info((CharSequence)("    " + kind + " " + id + " " + KubernetesHelper.summaryText(object)));
        }
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    Set<File> getDependencies() throws IOException {
        LinkedHashSet<File> dependnencies = new LinkedHashSet<File>();
        MavenProject project = this.getProject();
        Path dir = Paths.get(project.getBuild().getOutputDirectory(), "deps");
        if (!dir.toFile().exists() && !dir.toFile().mkdirs()) {
            throw new IOException("Cannot create temp directory at:" + dir.toAbsolutePath());
        }
        for (Artifact candidate : project.getDependencyArtifacts()) {
            File f = candidate.getFile();
            if (f == null) continue;
            if (f.getName().endsWith("jar") && AbstractFabric8Mojo.hasKubernetesJson(f)) {
                this.getLog().info((CharSequence)("Found file:" + f.getAbsolutePath()));
                FileInputStream fis = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    JarInputStream jis = new JarInputStream(fis);
                    Throwable throwable2 = null;
                    try {
                        Zips.unzip(new FileInputStream(f), dir.toFile());
                        File jsonPath = dir.resolve(DEFAULT_CONFIG_FILE_NAME).toFile();
                        if (!jsonPath.exists()) continue;
                        dependnencies.add(jsonPath);
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (jis == null) continue;
                        if (throwable2 != null) {
                            try {
                                jis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        jis.close();
                        continue;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fis.close();
                    continue;
                }
            }
            if (!AbstractFabric8Mojo.isKubernetesJsonArtifact(candidate.getClassifier(), candidate.getType())) continue;
            dependnencies.add(f);
        }
        return dependnencies;
    }

    static boolean isKubernetesJsonArtifact(String classifier, String type) {
        return Objects.equal((Object)"json", (Object)type) && Objects.equal((Object)"kubernetes", (Object)classifier);
    }

    static boolean hasKubernetesJson(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);
             JarInputStream jis = new JarInputStream(fis);){
            JarEntry entry = jis.getNextJarEntry();
            while (true) {
                if (entry != null) {
                    if (entry.getName().equals(DEFAULT_CONFIG_FILE_NAME)) {
                        boolean bl = true;
                        return bl;
                    }
                    entry = jis.getNextJarEntry();
                    continue;
                }
                break;
            }
        }
        return false;
    }

    protected void overrideTemplateParameters(Template template) {
        List parameters = template.getParameters();
        MavenProject project = this.getProject();
        if (parameters != null && project != null) {
            Properties properties = this.getProjectAndFabric8Properties(project);
            boolean missingProperty = false;
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                String name = "fabric8.apply." + parameterName;
                String propertyValue = properties.getProperty(name);
                if (propertyValue != null) {
                    this.getLog().info((CharSequence)("Overriding template parameter " + name + " with value: " + propertyValue));
                    parameter.setValue(propertyValue);
                    continue;
                }
                missingProperty = true;
                this.getLog().info((CharSequence)("No property defined for template parameter: " + name));
            }
            if (missingProperty) {
                this.getLog().debug((CharSequence)("Current properties " + new TreeSet<Object>(properties.keySet())));
            }
        }
    }

    protected Properties getProjectAndFabric8Properties(MavenProject project) {
        Properties properties = project.getProperties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }
}

