/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.support;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.maven.support.JsonSchemaProperty;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JsonSchema {
    private String id;
    @JsonProperty(value="$schema")
    private String uri;
    private String type = "object";
    private Map<String, JsonSchemaProperty> properties = new HashMap<String, JsonSchemaProperty>();
    private Set<String> required = new LinkedHashSet<String>();

    public JsonSchemaProperty getOrCreateProperty(String name) {
        JsonSchemaProperty property = this.properties.get(name);
        if (property == null) {
            property = new JsonSchemaProperty();
            this.properties.put(name, property);
        }
        return property;
    }

    public void addRequired(String property) {
        this.required.add(property);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, JsonSchemaProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, JsonSchemaProperty> properties) {
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Set<String> getRequired() {
        return this.required;
    }

    public void setRequired(Set<String> required) {
        this.required = new LinkedHashSet<String>(required);
    }
}

