/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.ianaservicehelper;

import io.fabric8.ianaservicehelper.PortAndProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class Helper {
    private static Map<PortAndProtocol, Set<String>> servicePortsMap = null;
    private static Map<String, Set<PortAndProtocol>> serviceNamesMap = null;

    public static Set<String> serviceNames(int portNumber) throws IOException {
        return Helper.serviceNames(new PortAndProtocol(portNumber, "tcp"));
    }

    public static Set<String> serviceNames(int portNumber, String protocol) throws IOException {
        return Helper.serviceNames(new PortAndProtocol(portNumber, protocol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> serviceNames(PortAndProtocol pp) throws IOException {
        if (servicePortsMap != null) return servicePortsMap.get(pp);
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (servicePortsMap != null) return servicePortsMap.get(pp);
            InputStream is = Helper.class.getResourceAsStream("ianaservicenamemap");
            GZIPInputStream gz = new GZIPInputStream(is);
            try (ObjectInputStream ois = new ObjectInputStream(gz);){
                servicePortsMap = (HashMap)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return servicePortsMap.get(pp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<PortAndProtocol> servicePorts(String serviceName) throws IOException {
        if (serviceNamesMap != null) return serviceNamesMap.get(serviceName);
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (serviceNamesMap != null) return serviceNamesMap.get(serviceName);
            InputStream is = Helper.class.getResourceAsStream("ianaserviceportmap");
            GZIPInputStream gz = new GZIPInputStream(is);
            try (ObjectInputStream ois = new ObjectInputStream(gz);){
                serviceNamesMap = (HashMap)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serviceNamesMap.get(serviceName);
        }
    }

    public static PortAndProtocol servicePort(String serviceName) throws IOException {
        return Helper.servicePort(serviceName, "tcp");
    }

    public static PortAndProtocol servicePort(String serviceName, String protocol) throws IOException {
        Set<PortAndProtocol> servicePorts = Helper.servicePorts(serviceName);
        if (servicePorts == null) {
            return null;
        }
        for (PortAndProtocol pp : servicePorts) {
            if (!pp.getProtocol().equalsIgnoreCase(protocol)) continue;
            return pp;
        }
        return null;
    }
}

