/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent;
import io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ClientTLSSettingsBuilder
extends ClientTLSSettingsFluentImpl<ClientTLSSettingsBuilder>
implements VisitableBuilder<ClientTLSSettings, ClientTLSSettingsBuilder> {
    ClientTLSSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public ClientTLSSettingsBuilder() {
        this(false);
    }

    public ClientTLSSettingsBuilder(Boolean validationEnabled) {
        this(new ClientTLSSettings(), validationEnabled);
    }

    public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClientTLSSettings(), validationEnabled);
    }

    public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent, ClientTLSSettings instance) {
        this(fluent, instance, false);
    }

    public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent, ClientTLSSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCaCertificates(instance.getCaCertificates());
        fluent.withClientCertificate(instance.getClientCertificate());
        fluent.withCredentialName(instance.getCredentialName());
        fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        fluent.withMode(instance.getMode());
        fluent.withPrivateKey(instance.getPrivateKey());
        fluent.withSni(instance.getSni());
        fluent.withSubjectAltNames(instance.getSubjectAltNames());
        this.validationEnabled = validationEnabled;
    }

    public ClientTLSSettingsBuilder(ClientTLSSettings instance) {
        this(instance, (Boolean)false);
    }

    public ClientTLSSettingsBuilder(ClientTLSSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCaCertificates(instance.getCaCertificates());
        this.withClientCertificate(instance.getClientCertificate());
        this.withCredentialName(instance.getCredentialName());
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
        this.withMode(instance.getMode());
        this.withPrivateKey(instance.getPrivateKey());
        this.withSni(instance.getSni());
        this.withSubjectAltNames(instance.getSubjectAltNames());
        this.validationEnabled = validationEnabled;
    }

    public ClientTLSSettings build() {
        ClientTLSSettings buildable = new ClientTLSSettings(this.fluent.getCaCertificates(), this.fluent.getClientCertificate(), this.fluent.getCredentialName(), this.fluent.getInsecureSkipVerify(), this.fluent.getMode(), this.fluent.getPrivateKey(), this.fluent.getSni(), this.fluent.getSubjectAltNames());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTLSSettingsBuilder that = (ClientTLSSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

