/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.mock;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.client.NamespacedKnativeClient;
import io.fabric8.knative.mock.EnableKnativeMockClient;
import io.fabric8.knative.mock.KnativeMockServer;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KnativeMockServerExtension
extends KubernetesMockServerExtension {
    private KnativeMockServer knativeMockServer;
    private NamespacedKnativeClient knativeClient;

    protected void destroy() {
        this.knativeMockServer.destroy();
        this.knativeClient.close();
    }

    protected Class<?> getClientType() {
        return KnativeClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return KnativeMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableKnativeMockClient a = testClass.getAnnotation(EnableKnativeMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.knativeMockServer = a.crud() ? new KnativeMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new KnativeMockServer(a.https());
        this.knativeMockServer.init();
        this.knativeClient = this.knativeMockServer.createKnative();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.knativeClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.knativeMockServer));
    }
}

