/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.HTTPIngressRuleValue;
import io.fabric8.knative.internal.networking.v1alpha1.HTTPIngressRuleValueBuilder;
import io.fabric8.knative.internal.networking.v1alpha1.HTTPIngressRuleValueFluent;
import io.fabric8.knative.internal.networking.v1alpha1.IngressRule;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IngressRuleFluent<A extends IngressRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> hosts = new ArrayList<String>();
    private HTTPIngressRuleValueBuilder http;
    private String visibility;

    public IngressRuleFluent() {
    }

    public IngressRuleFluent(IngressRule instance) {
        IngressRule ingressRule = instance = instance != null ? instance : new IngressRule();
        if (instance != null) {
            this.withHosts(instance.getHosts());
            this.withHttp(instance.getHttp());
            this.withVisibility(instance.getVisibility());
            this.withHosts(instance.getHosts());
            this.withHttp(instance.getHttp());
            this.withVisibility(instance.getVisibility());
        }
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    public A withHttp(HTTPIngressRuleValue http) {
        this._visitables.get((Object)"http").remove((Object)this.http);
        if (http != null) {
            this.http = new HTTPIngressRuleValueBuilder(http);
            this._visitables.get((Object)"http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get((Object)"http").remove((Object)this.http);
        }
        return (A)((Object)this);
    }

    public boolean hasHttp() {
        return this.http != null;
    }

    public HttpNested<A> withNewHttp() {
        return new HttpNested(null);
    }

    public HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item) {
        return new HttpNested(item);
    }

    public HttpNested<A> editHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(null));
    }

    public HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(new HTTPIngressRuleValueBuilder().build()));
    }

    public HttpNested<A> editOrNewHttpLike(HTTPIngressRuleValue item) {
        return this.withNewHttpLike(Optional.ofNullable(this.buildHttp()).orElse(item));
    }

    public String getVisibility() {
        return this.visibility;
    }

    public A withVisibility(String visibility) {
        this.visibility = visibility;
        return (A)((Object)this);
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleFluent that = (IngressRuleFluent)((Object)o);
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals((Object)this.http, (Object)that.http)) {
            return false;
        }
        return Objects.equals(this.visibility, that.visibility);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hosts, this.http, this.visibility, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append((Object)((Object)this.http) + ",");
        }
        if (this.visibility != null) {
            sb.append("visibility:");
            sb.append(this.visibility);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpNested<N>
    extends HTTPIngressRuleValueFluent<HttpNested<N>>
    implements Nested<N> {
        HTTPIngressRuleValueBuilder builder;

        HttpNested(HTTPIngressRuleValue item) {
            this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }

        public N and() {
            return (N)IngressRuleFluent.this.withHttp(this.builder.build());
        }

        public N endHttp() {
            return this.and();
        }
    }
}

