/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ResourceCreator;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class Creators {
    private static final Map<Class, ResourceCreator> RESOURCE_CREATOR_MAP = new HashMap<Class, ResourceCreator>();

    private Creators() {
    }

    public static <T extends HasMetadata, C extends Client> void register(ResourceCreator<T> creator) {
        RESOURCE_CREATOR_MAP.put(creator.getKind(), creator);
    }

    public static <T extends HasMetadata, C extends Client> void unregister(ResourceCreator<T> creator) {
        RESOURCE_CREATOR_MAP.remove(creator.getKind());
    }

    public static <T extends HasMetadata, C extends Client> ResourceCreator<T> get(Class<T> type) {
        return RESOURCE_CREATOR_MAP.get(type);
    }

    static {
        for (ResourceCreator creator : ServiceLoader.load(ResourceCreator.class)) {
            Creators.register(creator);
        }
    }
}

