/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.cache.ReflectorWatcher;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflector<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private static final Logger log = LoggerFactory.getLogger(Reflector.class);
    private static final Long WATCH_RESTART_DELAY_MILLIS = 5000L;
    private final AtomicReference<String> lastSyncResourceVersion;
    private final Class<T> apiTypeClass;
    private final ListerWatcher<T, L> listerWatcher;
    private final Store<T> store;
    private final OperationContext operationContext;
    private final long resyncPeriodMillis;
    private final ScheduledExecutorService resyncExecutor;
    private final ReflectorWatcher<T> watcher;
    private final AtomicBoolean isActive;
    private final AtomicBoolean isWatcherStarted;
    private final AtomicReference<Watch> watch;

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, Store store, OperationContext operationContext, long resyncPeriodMillis) {
        this(apiTypeClass, listerWatcher, store, operationContext, resyncPeriodMillis, Executors.newSingleThreadScheduledExecutor());
    }

    public Reflector(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, Store store, OperationContext operationContext, long resyncPeriodMillis, ScheduledExecutorService resyncExecutor) {
        this.apiTypeClass = apiTypeClass;
        this.listerWatcher = listerWatcher;
        this.store = store;
        this.operationContext = operationContext;
        this.resyncPeriodMillis = resyncPeriodMillis;
        this.lastSyncResourceVersion = new AtomicReference();
        this.resyncExecutor = resyncExecutor;
        this.watcher = new ReflectorWatcher(store, this.lastSyncResourceVersion, this::startWatcher, this::reListAndSync);
        this.isActive = new AtomicBoolean(true);
        this.isWatcherStarted = new AtomicBoolean(false);
        this.watch = new AtomicReference<Object>(null);
    }

    private L getList() {
        return (L)((KubernetesResourceList)this.listerWatcher.list(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.FALSE)).withResourceVersion(null)).withTimeoutSeconds(null)).build(), this.operationContext.getNamespace(), this.operationContext));
    }

    public void listAndWatch() {
        log.info("Started ReflectorRunnable watch for {}", this.apiTypeClass);
        this.reListAndSync();
        this.startWatcher();
    }

    public void stop() {
        this.isActive.set(false);
        if (this.watch.get() != null) {
            this.watch.get().close();
            this.watch.set(null);
        }
    }

    public long getResyncPeriodMillis() {
        return this.resyncPeriodMillis;
    }

    private void reListAndSync() {
        this.store.isPopulated(false);
        L list = this.getList();
        String latestResourceVersion = list.getMetadata().getResourceVersion();
        log.debug("Listing items ({}) for resource {} v{}", new Object[]{list.getItems().size(), this.apiTypeClass, latestResourceVersion});
        this.lastSyncResourceVersion.set(latestResourceVersion);
        this.store.replace(list.getItems(), latestResourceVersion);
        if (!this.isActive.get()) {
            this.resyncExecutor.shutdown();
        }
    }

    private void startWatcher() {
        log.debug("Starting watcher for resource {} v{}", this.apiTypeClass, (Object)this.lastSyncResourceVersion.get());
        if (this.watch.get() != null) {
            log.debug("Stopping previous watcher");
            this.watch.get().close();
        }
        if (this.isWatcherStarted.get()) {
            log.debug("Watcher already started, delaying execution of new watcher");
            try {
                Thread.sleep(WATCH_RESTART_DELAY_MILLIS);
            }
            catch (InterruptedException e) {
                log.error("Reflector thread was interrupted");
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.isActive.get()) {
            this.isWatcherStarted.set(true);
            this.watch.set(this.listerWatcher.watch(((ListOptionsBuilder)((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withWatch(Boolean.TRUE)).withResourceVersion(this.lastSyncResourceVersion.get())).withTimeoutSeconds(null)).build(), this.operationContext.getNamespace(), this.operationContext, this.watcher));
        }
    }

    public String getLastSyncResourceVersion() {
        return this.lastSyncResourceVersion.get();
    }
}

