
                                          

package io.fabric8.kubernetes.client.handlers.admissionregistration.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.admissionregistration.v1beta1.MutatingWebhookConfigurationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MutatingWebhookConfigurationBuilder;

public class MutatingWebhookConfigurationHandler implements ResourceHandler<MutatingWebhookConfiguration, MutatingWebhookConfigurationBuilder> {

  @Override
  public String getKind() {
    return MutatingWebhookConfiguration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "admissionregistration.k8s.io/v1beta1";
      }

  @Override
  public MutatingWebhookConfigurationBuilder edit(MutatingWebhookConfiguration item) {
    return new MutatingWebhookConfigurationBuilder(item);
  }

  @Override
  public Resource<MutatingWebhookConfiguration> resource(OkHttpClient client, Config config, String namespace, MutatingWebhookConfiguration item) {
    return new MutatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
