
                                          

package io.fabric8.kubernetes.client.handlers.apps.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.DaemonSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;

public class DaemonSetHandler implements ResourceHandler<DaemonSet, DaemonSetBuilder> {

  @Override
  public String getKind() {
    return DaemonSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apps/v1";
      }

  @Override
  public DaemonSetBuilder edit(DaemonSet item) {
    return new DaemonSetBuilder(item);
  }

  @Override
  public Resource<DaemonSet> resource(OkHttpClient client, Config config, String namespace, DaemonSet item) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
