
                                          

package io.fabric8.kubernetes.client.handlers.batch.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.batch.v1.JobOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;

public class JobHandler implements ResourceHandler<Job, JobBuilder> {

  @Override
  public String getKind() {
    return Job.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "batch/v1";
      }

  @Override
  public JobBuilder edit(Job item) {
    return new JobBuilder(item);
  }

  @Override
  public Resource<Job> resource(OkHttpClient client, Config config, String namespace, Job item) {
    return new JobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
