
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ServiceAccountOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;

public class ServiceAccountHandler implements ResourceHandler<ServiceAccount, ServiceAccountBuilder> {

  @Override
  public String getKind() {
    return ServiceAccount.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ServiceAccountBuilder edit(ServiceAccount item) {
    return new ServiceAccountBuilder(item);
  }

  @Override
  public Resource<ServiceAccount> resource(OkHttpClient client, Config config, String namespace, ServiceAccount item) {
    return new ServiceAccountOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
