
                                          

package io.fabric8.kubernetes.client.handlers.networking.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.networking.v1.NetworkPolicyOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;

public class NetworkPolicyHandler implements ResourceHandler<NetworkPolicy, NetworkPolicyBuilder> {

  @Override
  public String getKind() {
    return NetworkPolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "networking.k8s.io/v1";
      }

  @Override
  public NetworkPolicyBuilder edit(NetworkPolicy item) {
    return new NetworkPolicyBuilder(item);
  }

  @Override
  public Resource<NetworkPolicy> resource(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
    return new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
