
                                          

package io.fabric8.kubernetes.client.handlers.rbac.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.rbac.v1.ClusterRoleOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;

public class ClusterRoleHandler implements ResourceHandler<ClusterRole, ClusterRoleBuilder> {

  @Override
  public String getKind() {
    return ClusterRole.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
      }

  @Override
  public ClusterRoleBuilder edit(ClusterRole item) {
    return new ClusterRoleBuilder(item);
  }

  @Override
  public Resource<ClusterRole> resource(OkHttpClient client, Config config, String namespace, ClusterRole item) {
    return new ClusterRoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
