
                                          

package io.fabric8.kubernetes.client.handlers.rbac.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.rbac.v1.RoleBindingOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;

public class RoleBindingHandler implements ResourceHandler<RoleBinding, RoleBindingBuilder> {

  @Override
  public String getKind() {
    return RoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
      }

  @Override
  public RoleBindingBuilder edit(RoleBinding item) {
    return new RoleBindingBuilder(item);
  }

  @Override
  public Resource<RoleBinding> resource(OkHttpClient client, Config config, String namespace, RoleBinding item) {
    return new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
