
                                          

package io.fabric8.kubernetes.client.handlers.scheduling.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.scheduling.v1.PriorityClassOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassBuilder;

public class PriorityClassHandler implements ResourceHandler<PriorityClass, PriorityClassBuilder> {

  @Override
  public String getKind() {
    return PriorityClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "scheduling.k8s.io/v1";
      }

  @Override
  public PriorityClassBuilder edit(PriorityClass item) {
    return new PriorityClassBuilder(item);
  }

  @Override
  public Resource<PriorityClass> resource(OkHttpClient client, Config config, String namespace, PriorityClass item) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
