package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenReviewSpecBuilder extends TokenReviewSpecFluentImpl<TokenReviewSpecBuilder> implements VisitableBuilder<TokenReviewSpec,TokenReviewSpecBuilder>{
  public TokenReviewSpecBuilder() {
    this(false);
  }
  public TokenReviewSpecBuilder(Boolean validationEnabled) {
    this(new TokenReviewSpec(), validationEnabled);
  }
  public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenReviewSpec(), validationEnabled);
  }
  public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent,TokenReviewSpec instance) {
    this(fluent, instance, false);
  }
  public TokenReviewSpecBuilder(TokenReviewSpecFluent<?> fluent,TokenReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAudiences(instance.getAudiences()); 
    fluent.withToken(instance.getToken()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TokenReviewSpecBuilder(TokenReviewSpec instance) {
    this(instance,false);
  }
  public TokenReviewSpecBuilder(TokenReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAudiences(instance.getAudiences()); 
    this.withToken(instance.getToken()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  TokenReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TokenReviewSpec build() {
    TokenReviewSpec buildable = new TokenReviewSpec(fluent.getAudiences(),fluent.getToken());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}