package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ParamKindBuilder extends ParamKindFluent<ParamKindBuilder> implements VisitableBuilder<ParamKind,ParamKindBuilder>{
  public ParamKindBuilder() {
    this(new ParamKind());
  }
  
  public ParamKindBuilder(ParamKindFluent<?> fluent) {
    this(fluent, new ParamKind());
  }
  
  public ParamKindBuilder(ParamKindFluent<?> fluent,ParamKind instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ParamKindBuilder(ParamKind instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ParamKindFluent<?> fluent;
  
  public ParamKind build() {
    ParamKind buildable = new ParamKind(fluent.getApiVersion(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}