package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomResourceValidationBuilder extends CustomResourceValidationFluent<CustomResourceValidationBuilder> implements VisitableBuilder<CustomResourceValidation,CustomResourceValidationBuilder>{
  public CustomResourceValidationBuilder() {
    this(new CustomResourceValidation());
  }
  
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent) {
    this(fluent, new CustomResourceValidation());
  }
  
  public CustomResourceValidationBuilder(CustomResourceValidationFluent<?> fluent,CustomResourceValidation instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomResourceValidationBuilder(CustomResourceValidation instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomResourceValidationFluent<?> fluent;
  
  public CustomResourceValidation build() {
    CustomResourceValidation buildable = new CustomResourceValidation(fluent.buildOpenAPIV3Schema());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}