package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetricStatusBuilder extends ObjectMetricStatusFluentImpl<ObjectMetricStatusBuilder> implements VisitableBuilder<ObjectMetricStatus,ObjectMetricStatusBuilder>{
  public ObjectMetricStatusBuilder() {
    this(false);
  }
  public ObjectMetricStatusBuilder(Boolean validationEnabled) {
    this(new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent,ObjectMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent,ObjectMetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAverageValue(instance.getAverageValue()); 
    fluent.withCurrentValue(instance.getCurrentValue()); 
    fluent.withMetricName(instance.getMetricName()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatus instance) {
    this(instance,false);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAverageValue(instance.getAverageValue()); 
    this.withCurrentValue(instance.getCurrentValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ObjectMetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectMetricStatus build() {
    ObjectMetricStatus buildable = new ObjectMetricStatus(fluent.getAverageValue(),fluent.getCurrentValue(),fluent.getMetricName(),fluent.getSelector(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}