package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ObjectMetricStatusFluentImpl<A extends ObjectMetricStatusFluent<A>> extends BaseFluent<A> implements ObjectMetricStatusFluent<A>{
  public ObjectMetricStatusFluentImpl() {
  }
  public ObjectMetricStatusFluentImpl(ObjectMetricStatus instance) {
    this.withCurrent(instance.getCurrent()); 
    this.withDescribedObject(instance.getDescribedObject()); 
    this.withMetric(instance.getMetric()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private MetricValueStatusBuilder current;
  private CrossVersionObjectReferenceBuilder describedObject;
  private MetricIdentifierBuilder metric;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCurrent instead.
   * @return The buildable object.
   */
  @Deprecated
  public MetricValueStatus getCurrent() {
    return this.current!=null ?this.current.build():null;
  }
  public MetricValueStatus buildCurrent() {
    return this.current!=null ?this.current.build():null;
  }
  public A withCurrent(MetricValueStatus current) {
    _visitables.get("current").remove(this.current);
    if (current!=null){ this.current= new MetricValueStatusBuilder(current); _visitables.get("current").add(this.current);} else { this.current = null; _visitables.get("current").remove(this.current); } return (A) this;
  }
  public Boolean hasCurrent() {
    return this.current != null;
  }
  public ObjectMetricStatusFluent.CurrentNested<A> withNewCurrent() {
    return new ObjectMetricStatusFluentImpl.CurrentNestedImpl();
  }
  public ObjectMetricStatusFluent.CurrentNested<A> withNewCurrentLike(MetricValueStatus item) {
    return new ObjectMetricStatusFluentImpl.CurrentNestedImpl(item);
  }
  public ObjectMetricStatusFluent.CurrentNested<A> editCurrent() {
    return withNewCurrentLike(getCurrent());
  }
  public ObjectMetricStatusFluent.CurrentNested<A> editOrNewCurrent() {
    return withNewCurrentLike(getCurrent() != null ? getCurrent(): new MetricValueStatusBuilder().build());
  }
  public ObjectMetricStatusFluent.CurrentNested<A> editOrNewCurrentLike(MetricValueStatus item) {
    return withNewCurrentLike(getCurrent() != null ? getCurrent(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDescribedObject instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getDescribedObject() {
    return this.describedObject!=null ?this.describedObject.build():null;
  }
  public CrossVersionObjectReference buildDescribedObject() {
    return this.describedObject!=null ?this.describedObject.build():null;
  }
  public A withDescribedObject(CrossVersionObjectReference describedObject) {
    _visitables.get("describedObject").remove(this.describedObject);
    if (describedObject!=null){ this.describedObject= new CrossVersionObjectReferenceBuilder(describedObject); _visitables.get("describedObject").add(this.describedObject);} else { this.describedObject = null; _visitables.get("describedObject").remove(this.describedObject); } return (A) this;
  }
  public Boolean hasDescribedObject() {
    return this.describedObject != null;
  }
  public A withNewDescribedObject(String apiVersion,String kind,String name) {
    return (A)withDescribedObject(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public ObjectMetricStatusFluent.DescribedObjectNested<A> withNewDescribedObject() {
    return new ObjectMetricStatusFluentImpl.DescribedObjectNestedImpl();
  }
  public ObjectMetricStatusFluent.DescribedObjectNested<A> withNewDescribedObjectLike(CrossVersionObjectReference item) {
    return new ObjectMetricStatusFluentImpl.DescribedObjectNestedImpl(item);
  }
  public ObjectMetricStatusFluent.DescribedObjectNested<A> editDescribedObject() {
    return withNewDescribedObjectLike(getDescribedObject());
  }
  public ObjectMetricStatusFluent.DescribedObjectNested<A> editOrNewDescribedObject() {
    return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): new CrossVersionObjectReferenceBuilder().build());
  }
  public ObjectMetricStatusFluent.DescribedObjectNested<A> editOrNewDescribedObjectLike(CrossVersionObjectReference item) {
    return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetric instead.
   * @return The buildable object.
   */
  @Deprecated
  public MetricIdentifier getMetric() {
    return this.metric!=null ?this.metric.build():null;
  }
  public MetricIdentifier buildMetric() {
    return this.metric!=null ?this.metric.build():null;
  }
  public A withMetric(MetricIdentifier metric) {
    _visitables.get("metric").remove(this.metric);
    if (metric!=null){ this.metric= new MetricIdentifierBuilder(metric); _visitables.get("metric").add(this.metric);} else { this.metric = null; _visitables.get("metric").remove(this.metric); } return (A) this;
  }
  public Boolean hasMetric() {
    return this.metric != null;
  }
  public ObjectMetricStatusFluent.MetricNested<A> withNewMetric() {
    return new ObjectMetricStatusFluentImpl.MetricNestedImpl();
  }
  public ObjectMetricStatusFluent.MetricNested<A> withNewMetricLike(MetricIdentifier item) {
    return new ObjectMetricStatusFluentImpl.MetricNestedImpl(item);
  }
  public ObjectMetricStatusFluent.MetricNested<A> editMetric() {
    return withNewMetricLike(getMetric());
  }
  public ObjectMetricStatusFluent.MetricNested<A> editOrNewMetric() {
    return withNewMetricLike(getMetric() != null ? getMetric(): new MetricIdentifierBuilder().build());
  }
  public ObjectMetricStatusFluent.MetricNested<A> editOrNewMetricLike(MetricIdentifier item) {
    return withNewMetricLike(getMetric() != null ? getMetric(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl) o;
    if (current != null ? !current.equals(that.current) :that.current != null) return false;
    if (describedObject != null ? !describedObject.equals(that.describedObject) :that.describedObject != null) return false;
    if (metric != null ? !metric.equals(that.metric) :that.metric != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(current,  describedObject,  metric,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (current != null) { sb.append("current:"); sb.append(current + ","); }
    if (describedObject != null) { sb.append("describedObject:"); sb.append(describedObject + ","); }
    if (metric != null) { sb.append("metric:"); sb.append(metric + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CurrentNestedImpl<N> extends MetricValueStatusFluentImpl<ObjectMetricStatusFluent.CurrentNested<N>> implements ObjectMetricStatusFluent.CurrentNested<N>,Nested<N>{
    CurrentNestedImpl(MetricValueStatus item) {
      this.builder = new MetricValueStatusBuilder(this, item);
    }
    CurrentNestedImpl() {
      this.builder = new MetricValueStatusBuilder(this);
    }
    MetricValueStatusBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withCurrent(builder.build());
    }
    public N endCurrent() {
      return and();
    }
    
  }
  class DescribedObjectNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluent.DescribedObjectNested<N>> implements ObjectMetricStatusFluent.DescribedObjectNested<N>,Nested<N>{
    DescribedObjectNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    DescribedObjectNestedImpl() {
      this.builder = new CrossVersionObjectReferenceBuilder(this);
    }
    CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withDescribedObject(builder.build());
    }
    public N endDescribedObject() {
      return and();
    }
    
  }
  class MetricNestedImpl<N> extends MetricIdentifierFluentImpl<ObjectMetricStatusFluent.MetricNested<N>> implements ObjectMetricStatusFluent.MetricNested<N>,Nested<N>{
    MetricNestedImpl(MetricIdentifier item) {
      this.builder = new MetricIdentifierBuilder(this, item);
    }
    MetricNestedImpl() {
      this.builder = new MetricIdentifierBuilder(this);
    }
    MetricIdentifierBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withMetric(builder.build());
    }
    public N endMetric() {
      return and();
    }
    
  }
  
}