package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HPAScalingRulesFluent<A extends HPAScalingRulesFluent<A>> extends BaseFluent<A>{
  public HPAScalingRulesFluent() {
  }
  
  public HPAScalingRulesFluent(HPAScalingRules instance) {
    this.copyInstance(instance);
  }
  private ArrayList<HPAScalingPolicyBuilder> policies = new ArrayList<HPAScalingPolicyBuilder>();
  private String selectPolicy;
  private Integer stabilizationWindowSeconds;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HPAScalingRules instance) {
    instance = (instance != null ? instance : new HPAScalingRules());
    if (instance != null) {
          this.withPolicies(instance.getPolicies());
          this.withSelectPolicy(instance.getSelectPolicy());
          this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToPolicies(int index,HPAScalingPolicy item) {
    if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
    HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").add(index, builder); policies.add(index, builder);}
    return (A)this;
  }
  
  public A setToPolicies(int index,HPAScalingPolicy item) {
    if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
    HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
    if (index < 0 || index >= policies.size()) { _visitables.get("policies").add(builder); policies.add(builder); } else { _visitables.get("policies").set(index, builder); policies.set(index, builder);}
    return (A)this;
  }
  
  public A addToPolicies(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy... items) {
    if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
    for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A addAllToPolicies(Collection<HPAScalingPolicy> items) {
    if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
    for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
  }
  
  public A removeFromPolicies(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy... items) {
    if (this.policies == null) return (A)this;
    for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPolicies(Collection<HPAScalingPolicy> items) {
    if (this.policies == null) return (A)this;
    for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").remove(builder); this.policies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPolicies(Predicate<HPAScalingPolicyBuilder> predicate) {
    if (policies == null) return (A) this;
    final Iterator<HPAScalingPolicyBuilder> each = policies.iterator();
    final List visitables = _visitables.get("policies");
    while (each.hasNext()) {
      HPAScalingPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HPAScalingPolicy> buildPolicies() {
    return this.policies != null ? build(policies) : null;
  }
  
  public HPAScalingPolicy buildPolicy(int index) {
    return this.policies.get(index).build();
  }
  
  public HPAScalingPolicy buildFirstPolicy() {
    return this.policies.get(0).build();
  }
  
  public HPAScalingPolicy buildLastPolicy() {
    return this.policies.get(policies.size() - 1).build();
  }
  
  public HPAScalingPolicy buildMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
      for (HPAScalingPolicyBuilder item : policies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
      for (HPAScalingPolicyBuilder item : policies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPolicies(List<HPAScalingPolicy> policies) {
    if (this.policies != null) {
      this._visitables.get("policies").clear();
    }
    if (policies != null) {
        this.policies = new ArrayList();
        for (HPAScalingPolicy item : policies) {
          this.addToPolicies(item);
        }
    } else {
      this.policies = null;
    }
    return (A) this;
  }
  
  public A withPolicies(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy... policies) {
    if (this.policies != null) {
        this.policies.clear();
        _visitables.remove("policies");
    }
    if (policies != null) {
      for (HPAScalingPolicy item : policies) {
        this.addToPolicies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPolicies() {
    return this.policies != null && !this.policies.isEmpty();
  }
  
  public A addNewPolicy(Integer periodSeconds,String type,Integer value) {
    return (A)addToPolicies(new HPAScalingPolicy(periodSeconds, type, value));
  }
  
  public PoliciesNested<A> addNewPolicy() {
    return new PoliciesNested(-1, null);
  }
  
  public PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item) {
    return new PoliciesNested(-1, item);
  }
  
  public PoliciesNested<A> setNewPolicyLike(int index,HPAScalingPolicy item) {
    return new PoliciesNested(index, item);
  }
  
  public PoliciesNested<A> editPolicy(int index) {
    if (policies.size() <= index) throw new RuntimeException("Can't edit policies. Index exceeds size.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editFirstPolicy() {
    if (policies.size() == 0) throw new RuntimeException("Can't edit first policies. The list is empty.");
    return setNewPolicyLike(0, buildPolicy(0));
  }
  
  public PoliciesNested<A> editLastPolicy() {
    int index = policies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last policies. The list is empty.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public PoliciesNested<A> editMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<policies.size();i++) { 
    if (predicate.test(policies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching policies. No match found.");
    return setNewPolicyLike(index, buildPolicy(index));
  }
  
  public String getSelectPolicy() {
    return this.selectPolicy;
  }
  
  public A withSelectPolicy(String selectPolicy) {
    this.selectPolicy = selectPolicy;
    return (A) this;
  }
  
  public boolean hasSelectPolicy() {
    return this.selectPolicy != null;
  }
  
  public Integer getStabilizationWindowSeconds() {
    return this.stabilizationWindowSeconds;
  }
  
  public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
    this.stabilizationWindowSeconds = stabilizationWindowSeconds;
    return (A) this;
  }
  
  public boolean hasStabilizationWindowSeconds() {
    return this.stabilizationWindowSeconds != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HPAScalingRulesFluent that = (HPAScalingRulesFluent) o;
    if (!java.util.Objects.equals(policies, that.policies)) return false;
    if (!java.util.Objects.equals(selectPolicy, that.selectPolicy)) return false;
    if (!java.util.Objects.equals(stabilizationWindowSeconds, that.stabilizationWindowSeconds)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(policies,  selectPolicy,  stabilizationWindowSeconds,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (policies != null && !policies.isEmpty()) { sb.append("policies:"); sb.append(policies + ","); }
    if (selectPolicy != null) { sb.append("selectPolicy:"); sb.append(selectPolicy + ","); }
    if (stabilizationWindowSeconds != null) { sb.append("stabilizationWindowSeconds:"); sb.append(stabilizationWindowSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PoliciesNested<N> extends HPAScalingPolicyFluent<PoliciesNested<N>> implements Nested<N>{
    PoliciesNested(int index,HPAScalingPolicy item) {
      this.index = index;
      this.builder = new HPAScalingPolicyBuilder(this, item);
    }
    HPAScalingPolicyBuilder builder;
    int index;
    
    public N and() {
      return (N) HPAScalingRulesFluent.this.setToPolicies(index,builder.build());
    }
    
    public N endPolicy() {
      return and();
    }
    
  
  }

}