package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CrossVersionObjectReferenceBuilder extends CrossVersionObjectReferenceFluent<CrossVersionObjectReferenceBuilder> implements VisitableBuilder<CrossVersionObjectReference,CrossVersionObjectReferenceBuilder>{
  public CrossVersionObjectReferenceBuilder() {
    this(new CrossVersionObjectReference());
  }
  
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent) {
    this(fluent, new CrossVersionObjectReference());
  }
  
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReferenceFluent<?> fluent,CrossVersionObjectReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CrossVersionObjectReferenceBuilder(CrossVersionObjectReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CrossVersionObjectReferenceFluent<?> fluent;
  
  public CrossVersionObjectReference build() {
    CrossVersionObjectReference buildable = new CrossVersionObjectReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}