package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ObjectMetricSourceFluent<A extends ObjectMetricSourceFluent<A>> extends BaseFluent<A>{
  public ObjectMetricSourceFluent() {
  }
  
  public ObjectMetricSourceFluent(ObjectMetricSource instance) {
    this.copyInstance(instance);
  }
  private CrossVersionObjectReferenceBuilder describedObject;
  private MetricIdentifierBuilder metric;
  private MetricTargetBuilder target;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ObjectMetricSource instance) {
    instance = (instance != null ? instance : new ObjectMetricSource());
    if (instance != null) {
          this.withDescribedObject(instance.getDescribedObject());
          this.withMetric(instance.getMetric());
          this.withTarget(instance.getTarget());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public CrossVersionObjectReference buildDescribedObject() {
    return this.describedObject != null ? this.describedObject.build() : null;
  }
  
  public A withDescribedObject(CrossVersionObjectReference describedObject) {
    this._visitables.remove("describedObject");
    if (describedObject != null) {
        this.describedObject = new CrossVersionObjectReferenceBuilder(describedObject);
        this._visitables.get("describedObject").add(this.describedObject);
    } else {
        this.describedObject = null;
        this._visitables.get("describedObject").remove(this.describedObject);
    }
    return (A) this;
  }
  
  public boolean hasDescribedObject() {
    return this.describedObject != null;
  }
  
  public A withNewDescribedObject(String apiVersion,String kind,String name) {
    return (A)withDescribedObject(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  
  public DescribedObjectNested<A> withNewDescribedObject() {
    return new DescribedObjectNested(null);
  }
  
  public DescribedObjectNested<A> withNewDescribedObjectLike(CrossVersionObjectReference item) {
    return new DescribedObjectNested(item);
  }
  
  public DescribedObjectNested<A> editDescribedObject() {
    return withNewDescribedObjectLike(java.util.Optional.ofNullable(buildDescribedObject()).orElse(null));
  }
  
  public DescribedObjectNested<A> editOrNewDescribedObject() {
    return withNewDescribedObjectLike(java.util.Optional.ofNullable(buildDescribedObject()).orElse(new CrossVersionObjectReferenceBuilder().build()));
  }
  
  public DescribedObjectNested<A> editOrNewDescribedObjectLike(CrossVersionObjectReference item) {
    return withNewDescribedObjectLike(java.util.Optional.ofNullable(buildDescribedObject()).orElse(item));
  }
  
  public MetricIdentifier buildMetric() {
    return this.metric != null ? this.metric.build() : null;
  }
  
  public A withMetric(MetricIdentifier metric) {
    this._visitables.remove("metric");
    if (metric != null) {
        this.metric = new MetricIdentifierBuilder(metric);
        this._visitables.get("metric").add(this.metric);
    } else {
        this.metric = null;
        this._visitables.get("metric").remove(this.metric);
    }
    return (A) this;
  }
  
  public boolean hasMetric() {
    return this.metric != null;
  }
  
  public MetricNested<A> withNewMetric() {
    return new MetricNested(null);
  }
  
  public MetricNested<A> withNewMetricLike(MetricIdentifier item) {
    return new MetricNested(item);
  }
  
  public MetricNested<A> editMetric() {
    return withNewMetricLike(java.util.Optional.ofNullable(buildMetric()).orElse(null));
  }
  
  public MetricNested<A> editOrNewMetric() {
    return withNewMetricLike(java.util.Optional.ofNullable(buildMetric()).orElse(new MetricIdentifierBuilder().build()));
  }
  
  public MetricNested<A> editOrNewMetricLike(MetricIdentifier item) {
    return withNewMetricLike(java.util.Optional.ofNullable(buildMetric()).orElse(item));
  }
  
  public MetricTarget buildTarget() {
    return this.target != null ? this.target.build() : null;
  }
  
  public A withTarget(MetricTarget target) {
    this._visitables.remove("target");
    if (target != null) {
        this.target = new MetricTargetBuilder(target);
        this._visitables.get("target").add(this.target);
    } else {
        this.target = null;
        this._visitables.get("target").remove(this.target);
    }
    return (A) this;
  }
  
  public boolean hasTarget() {
    return this.target != null;
  }
  
  public TargetNested<A> withNewTarget() {
    return new TargetNested(null);
  }
  
  public TargetNested<A> withNewTargetLike(MetricTarget item) {
    return new TargetNested(item);
  }
  
  public TargetNested<A> editTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(null));
  }
  
  public TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(new MetricTargetBuilder().build()));
  }
  
  public TargetNested<A> editOrNewTargetLike(MetricTarget item) {
    return withNewTargetLike(java.util.Optional.ofNullable(buildTarget()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ObjectMetricSourceFluent that = (ObjectMetricSourceFluent) o;
    if (!java.util.Objects.equals(describedObject, that.describedObject)) return false;
    if (!java.util.Objects.equals(metric, that.metric)) return false;
    if (!java.util.Objects.equals(target, that.target)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(describedObject,  metric,  target,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (describedObject != null) { sb.append("describedObject:"); sb.append(describedObject + ","); }
    if (metric != null) { sb.append("metric:"); sb.append(metric + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DescribedObjectNested<N> extends CrossVersionObjectReferenceFluent<DescribedObjectNested<N>> implements Nested<N>{
    DescribedObjectNested(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    CrossVersionObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ObjectMetricSourceFluent.this.withDescribedObject(builder.build());
    }
    
    public N endDescribedObject() {
      return and();
    }
    
  
  }
  public class MetricNested<N> extends MetricIdentifierFluent<MetricNested<N>> implements Nested<N>{
    MetricNested(MetricIdentifier item) {
      this.builder = new MetricIdentifierBuilder(this, item);
    }
    MetricIdentifierBuilder builder;
    
    public N and() {
      return (N) ObjectMetricSourceFluent.this.withMetric(builder.build());
    }
    
    public N endMetric() {
      return and();
    }
    
  
  }
  public class TargetNested<N> extends MetricTargetFluent<TargetNested<N>> implements Nested<N>{
    TargetNested(MetricTarget item) {
      this.builder = new MetricTargetBuilder(this, item);
    }
    MetricTargetBuilder builder;
    
    public N and() {
      return (N) ObjectMetricSourceFluent.this.withTarget(builder.build());
    }
    
    public N endTarget() {
      return and();
    }
    
  
  }

}