package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.APIServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.APIServiceSpecFluent<A> {

    private java.lang.String caBundle;
    private java.lang.String group;
    private java.lang.Integer groupPriorityMinimum;
    private java.lang.Boolean insecureSkipTLSVerify;
    private io.fabric8.kubernetes.api.model.ServiceReferenceBuilder service;
    private java.lang.String version;
    private java.lang.Integer versionPriority;

    public APIServiceSpecFluentImpl() {
    }

    public APIServiceSpecFluentImpl(io.fabric8.kubernetes.api.model.APIServiceSpec instance) {
        this.withCaBundle(instance.getCaBundle()); 
        this.withGroup(instance.getGroup()); 
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        this.withService(instance.getService()); 
        this.withVersion(instance.getVersion()); 
        this.withVersionPriority(instance.getVersionPriority()); 
    }

    public java.lang.String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(java.lang.String caBundle) {
        this.caBundle=caBundle; return (A) this;
    }

    public java.lang.Boolean hasCaBundle() {
        return this.caBundle != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaBundle instead.
     */
        public A withNewCaBundle(java.lang.String arg0) {
        return (A)withCaBundle(new String(arg0));
    }

    public java.lang.String getGroup() {
        return this.group;
    }

    public A withGroup(java.lang.String group) {
        this.group=group; return (A) this;
    }

    public java.lang.Boolean hasGroup() {
        return this.group != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGroup instead.
     */
        public A withNewGroup(java.lang.String arg0) {
        return (A)withGroup(new String(arg0));
    }

    public java.lang.Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public A withGroupPriorityMinimum(java.lang.Integer groupPriorityMinimum) {
        this.groupPriorityMinimum=groupPriorityMinimum; return (A) this;
    }

    public java.lang.Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    public java.lang.Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public A withInsecureSkipTLSVerify(java.lang.Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify=insecureSkipTLSVerify; return (A) this;
    }

    public java.lang.Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildService instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ServiceReference getService() {
        return this.service!=null?this.service.build():null;
    }

    public io.fabric8.kubernetes.api.model.ServiceReference buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(io.fabric8.kubernetes.api.model.ServiceReference service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new io.fabric8.kubernetes.api.model.ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public java.lang.Boolean hasService() {
        return this.service != null;
    }

    public A withNewService(java.lang.String name,java.lang.String namespace,java.lang.Integer port) {
        return (A)withService(new ServiceReference(name, namespace, port));
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new io.fabric8.kubernetes.api.model.APIServiceSpecFluentImpl.ServiceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(io.fabric8.kubernetes.api.model.ServiceReference item) {
        return new io.fabric8.kubernetes.api.model.APIServiceSpecFluentImpl.ServiceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new io.fabric8.kubernetes.api.model.ServiceReferenceBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(io.fabric8.kubernetes.api.model.ServiceReference item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    public java.lang.String getVersion() {
        return this.version;
    }

    public A withVersion(java.lang.String version) {
        this.version=version; return (A) this;
    }

    public java.lang.Boolean hasVersion() {
        return this.version != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withVersion instead.
     */
        public A withNewVersion(java.lang.String arg0) {
        return (A)withVersion(new String(arg0));
    }

    public java.lang.Integer getVersionPriority() {
        return this.versionPriority;
    }

    public A withVersionPriority(java.lang.Integer versionPriority) {
        this.versionPriority=versionPriority; return (A) this;
    }

    public java.lang.Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        APIServiceSpecFluentImpl that = (APIServiceSpecFluentImpl) o;
        if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (groupPriorityMinimum != null ? !groupPriorityMinimum.equals(that.groupPriorityMinimum) :that.groupPriorityMinimum != null) return false;
        if (insecureSkipTLSVerify != null ? !insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) :that.insecureSkipTLSVerify != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (versionPriority != null ? !versionPriority.equals(that.versionPriority) :that.versionPriority != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(caBundle,  group,  groupPriorityMinimum,  insecureSkipTLSVerify,  service,  version,  versionPriority,  super.hashCode());
    }

    public class ServiceNestedImpl<N> extends io.fabric8.kubernetes.api.model.ServiceReferenceFluentImpl<io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<N>> implements io.fabric8.kubernetes.api.model.APIServiceSpecFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ServiceReferenceBuilder builder;

            ServiceNestedImpl(io.fabric8.kubernetes.api.model.ServiceReference item) {
                this.builder = new io.fabric8.kubernetes.api.model.ServiceReferenceBuilder(this, item);
                        
            }

            ServiceNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ServiceReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) APIServiceSpecFluentImpl.this.withService(builder.build());
            }

            public N endService() {
                return and();
            }
    }


}
