package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DeleteOptionsFluentImpl<A extends io.fabric8.kubernetes.api.model.DeleteOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.DeleteOptionsFluent<A> {

    private java.lang.String apiVersion;
    private java.util.List<java.lang.String> dryRun = new java.util.ArrayList<java.lang.String>();
    private java.lang.Long gracePeriodSeconds;
    private java.lang.String kind;
    private java.lang.Boolean orphanDependents;
    private io.fabric8.kubernetes.api.model.PreconditionsBuilder preconditions;
    private java.lang.String propagationPolicy;

    public DeleteOptionsFluentImpl() {
    }

    public DeleteOptionsFluentImpl(io.fabric8.kubernetes.api.model.DeleteOptions instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withDryRun(instance.getDryRun()); 
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); 
        this.withKind(instance.getKind()); 
        this.withOrphanDependents(instance.getOrphanDependents()); 
        this.withPreconditions(instance.getPreconditions()); 
        this.withPropagationPolicy(instance.getPropagationPolicy()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public A addToDryRun(int index,java.lang.String item) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        this.dryRun.add(index, item);
        return (A)this;
    }

    public A setToDryRun(int index,java.lang.String item) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        this.dryRun.set(index, item); return (A)this;
    }

    public A addToDryRun(java.lang.String... items) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dryRun.add(item);} return (A)this;
    }

    public A addAllToDryRun(java.util.Collection<java.lang.String> items) {
        if (this.dryRun == null) {this.dryRun = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.dryRun.add(item);} return (A)this;
    }

    public A removeFromDryRun(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
    }

    public A removeAllFromDryRun(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.dryRun!= null){ this.dryRun.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getDryRun() {
        return this.dryRun;
    }

    public java.lang.String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public java.lang.String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public java.lang.String getLastDryRun() {
        return this.dryRun.get(dryRun.size() - 1);
    }

    public java.lang.String getMatchingDryRun(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dryRun) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingDryRun(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: dryRun) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDryRun(java.util.List<java.lang.String> dryRun) {
        if (this.dryRun != null) { _visitables.get("dryRun").removeAll(this.dryRun);}
        if (dryRun != null) {this.dryRun = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : dryRun){this.addToDryRun(item);}} else { this.dryRun = null;} return (A) this;
    }

    public A withDryRun(java.lang.String... dryRun) {
        if (this.dryRun != null) {this.dryRun.clear();}
        if (dryRun != null) {for (java.lang.String item :dryRun){ this.addToDryRun(item);}} return (A) this;
    }

    public java.lang.Boolean hasDryRun() {
        return dryRun != null && !dryRun.isEmpty();
    }

    public A addNewDryRun(java.lang.String arg0) {
        return (A)addToDryRun(new String(arg0));
    }

    public java.lang.Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public A withGracePeriodSeconds(java.lang.Long gracePeriodSeconds) {
        this.gracePeriodSeconds=gracePeriodSeconds; return (A) this;
    }

    public java.lang.Boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    public java.lang.Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    public A withOrphanDependents(java.lang.Boolean orphanDependents) {
        this.orphanDependents=orphanDependents; return (A) this;
    }

    public java.lang.Boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPreconditions instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Preconditions getPreconditions() {
        return this.preconditions!=null?this.preconditions.build():null;
    }

    public io.fabric8.kubernetes.api.model.Preconditions buildPreconditions() {
        return this.preconditions!=null?this.preconditions.build():null;
    }

    public A withPreconditions(io.fabric8.kubernetes.api.model.Preconditions preconditions) {
        _visitables.get("preconditions").remove(this.preconditions);
        if (preconditions!=null){ this.preconditions= new io.fabric8.kubernetes.api.model.PreconditionsBuilder(preconditions); _visitables.get("preconditions").add(this.preconditions);} return (A) this;
    }

    public java.lang.Boolean hasPreconditions() {
        return this.preconditions != null;
    }

    public A withNewPreconditions(java.lang.String resourceVersion,java.lang.String uid) {
        return (A)withPreconditions(new Preconditions(resourceVersion, uid));
    }

    public io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions() {
        return new io.fabric8.kubernetes.api.model.DeleteOptionsFluentImpl.PreconditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(io.fabric8.kubernetes.api.model.Preconditions item) {
        return new io.fabric8.kubernetes.api.model.DeleteOptionsFluentImpl.PreconditionsNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<A> editPreconditions() {
        return withNewPreconditionsLike(getPreconditions());
    }

    public io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditions() {
        return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): new io.fabric8.kubernetes.api.model.PreconditionsBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<A> editOrNewPreconditionsLike(io.fabric8.kubernetes.api.model.Preconditions item) {
        return withNewPreconditionsLike(getPreconditions() != null ? getPreconditions(): item);
    }

    public java.lang.String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public A withPropagationPolicy(java.lang.String propagationPolicy) {
        this.propagationPolicy=propagationPolicy; return (A) this;
    }

    public java.lang.Boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPropagationPolicy instead.
     */
        public A withNewPropagationPolicy(java.lang.String arg0) {
        return (A)withPropagationPolicy(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (dryRun != null ? !dryRun.equals(that.dryRun) :that.dryRun != null) return false;
        if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (orphanDependents != null ? !orphanDependents.equals(that.orphanDependents) :that.orphanDependents != null) return false;
        if (preconditions != null ? !preconditions.equals(that.preconditions) :that.preconditions != null) return false;
        if (propagationPolicy != null ? !propagationPolicy.equals(that.propagationPolicy) :that.propagationPolicy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  dryRun,  gracePeriodSeconds,  kind,  orphanDependents,  preconditions,  propagationPolicy,  super.hashCode());
    }

    public class PreconditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PreconditionsFluentImpl<io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<N>> implements io.fabric8.kubernetes.api.model.DeleteOptionsFluent.PreconditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PreconditionsBuilder builder;

            PreconditionsNestedImpl(io.fabric8.kubernetes.api.model.Preconditions item) {
                this.builder = new io.fabric8.kubernetes.api.model.PreconditionsBuilder(this, item);
                        
            }

            PreconditionsNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PreconditionsBuilder(this);
                        
            }

            public N and() {
                return (N) DeleteOptionsFluentImpl.this.withPreconditions(builder.build());
            }

            public N endPreconditions() {
                return and();
            }
    }


}
