package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

public interface EphemeralContainerFluent<A extends io.fabric8.kubernetes.api.model.EphemeralContainerFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToArgs(int index,java.lang.String item);
    public A setToArgs(int index,java.lang.String item);
    public A addToArgs(java.lang.String... items);
    public A addAllToArgs(java.util.Collection<java.lang.String> items);
    public A removeFromArgs(java.lang.String... items);
    public A removeAllFromArgs(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getArgs();
    public java.lang.String getArg(int index);
    public java.lang.String getFirstArg();
    public java.lang.String getLastArg();
    public java.lang.String getMatchingArg(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingArg(java.util.function.Predicate<java.lang.String> predicate);
    public A withArgs(java.util.List<java.lang.String> args);
    public A withArgs(java.lang.String... args);
    public java.lang.Boolean hasArgs();
    public A addNewArg(java.lang.String arg0);
    public A addToCommand(int index,java.lang.String item);
    public A setToCommand(int index,java.lang.String item);
    public A addToCommand(java.lang.String... items);
    public A addAllToCommand(java.util.Collection<java.lang.String> items);
    public A removeFromCommand(java.lang.String... items);
    public A removeAllFromCommand(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getCommand();
    public java.lang.String getCommand(int index);
    public java.lang.String getFirstCommand();
    public java.lang.String getLastCommand();
    public java.lang.String getMatchingCommand(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingCommand(java.util.function.Predicate<java.lang.String> predicate);
    public A withCommand(java.util.List<java.lang.String> command);
    public A withCommand(java.lang.String... command);
    public java.lang.Boolean hasCommand();
    public A addNewCommand(java.lang.String arg0);
    public A addToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item);
    public A setToEnv(int index,io.fabric8.kubernetes.api.model.EnvVar item);
    public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
    public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items);
    public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items);
    public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items);
    public A removeMatchingFromEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnv instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv();
    public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> buildEnv();
    public io.fabric8.kubernetes.api.model.EnvVar buildEnv(int index);
    public io.fabric8.kubernetes.api.model.EnvVar buildFirstEnv();
    public io.fabric8.kubernetes.api.model.EnvVar buildLastEnv();
    public io.fabric8.kubernetes.api.model.EnvVar buildMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate);
    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate);
    public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env);
    public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env);
    public java.lang.Boolean hasEnv();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> addNewEnv();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> addNewEnvLike(io.fabric8.kubernetes.api.model.EnvVar item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> setNewEnvLike(int index,io.fabric8.kubernetes.api.model.EnvVar item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editEnv(int index);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editFirstEnv();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editLastEnv();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVarBuilder> predicate);
    public A addToEnvFrom(int index,io.fabric8.kubernetes.api.model.EnvFromSource item);
    public A setToEnvFrom(int index,io.fabric8.kubernetes.api.model.EnvFromSource item);
    public A addToEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items);
    public A addAllToEnvFrom(java.util.Collection<io.fabric8.kubernetes.api.model.EnvFromSource> items);
    public A removeFromEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items);
    public A removeAllFromEnvFrom(java.util.Collection<io.fabric8.kubernetes.api.model.EnvFromSource> items);
    public A removeMatchingFromEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnvFrom instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> getEnvFrom();
    public java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> buildEnvFrom();
    public io.fabric8.kubernetes.api.model.EnvFromSource buildEnvFrom(int index);
    public io.fabric8.kubernetes.api.model.EnvFromSource buildFirstEnvFrom();
    public io.fabric8.kubernetes.api.model.EnvFromSource buildLastEnvFrom();
    public io.fabric8.kubernetes.api.model.EnvFromSource buildMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate);
    public A withEnvFrom(java.util.List<io.fabric8.kubernetes.api.model.EnvFromSource> envFrom);
    public A withEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... envFrom);
    public java.lang.Boolean hasEnvFrom();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> addNewEnvFrom();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> addNewEnvFromLike(io.fabric8.kubernetes.api.model.EnvFromSource item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index,io.fabric8.kubernetes.api.model.EnvFromSource item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editEnvFrom(int index);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editFirstEnvFrom();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editLastEnvFrom();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<A> editMatchingEnvFrom(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvFromSourceBuilder> predicate);
    public java.lang.String getImage();
    public A withImage(java.lang.String image);
    public java.lang.Boolean hasImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String arg0);
    public java.lang.String getImagePullPolicy();
    public A withImagePullPolicy(java.lang.String imagePullPolicy);
    public java.lang.Boolean hasImagePullPolicy();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImagePullPolicy instead.
     */
        public A withNewImagePullPolicy(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLifecycle instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Lifecycle getLifecycle();
    public io.fabric8.kubernetes.api.model.Lifecycle buildLifecycle();
    public A withLifecycle(io.fabric8.kubernetes.api.model.Lifecycle lifecycle);
    public java.lang.Boolean hasLifecycle();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> withNewLifecycle();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> withNewLifecycleLike(io.fabric8.kubernetes.api.model.Lifecycle item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editLifecycle();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycle();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(io.fabric8.kubernetes.api.model.Lifecycle item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getLivenessProbe();
    public io.fabric8.kubernetes.api.model.Probe buildLivenessProbe();
    public A withLivenessProbe(io.fabric8.kubernetes.api.model.Probe livenessProbe);
    public java.lang.Boolean hasLivenessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    public java.lang.String getName();
    public A withName(java.lang.String name);
    public java.lang.Boolean hasName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0);
    public A addToPorts(int index,io.fabric8.kubernetes.api.model.ContainerPort item);
    public A setToPorts(int index,io.fabric8.kubernetes.api.model.ContainerPort item);
    public A addToPorts(io.fabric8.kubernetes.api.model.ContainerPort... items);
    public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerPort> items);
    public A removeFromPorts(io.fabric8.kubernetes.api.model.ContainerPort... items);
    public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.ContainerPort> items);
    public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPorts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> getPorts();
    public java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> buildPorts();
    public io.fabric8.kubernetes.api.model.ContainerPort buildPort(int index);
    public io.fabric8.kubernetes.api.model.ContainerPort buildFirstPort();
    public io.fabric8.kubernetes.api.model.ContainerPort buildLastPort();
    public io.fabric8.kubernetes.api.model.ContainerPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate);
    public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate);
    public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.ContainerPort> ports);
    public A withPorts(io.fabric8.kubernetes.api.model.ContainerPort... ports);
    public java.lang.Boolean hasPorts();
    public A addNewPort(java.lang.Integer containerPort,java.lang.String hostIP,java.lang.Integer hostPort,java.lang.String name,java.lang.String protocol);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.ContainerPort item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> setNewPortLike(int index,io.fabric8.kubernetes.api.model.ContainerPort item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerPortBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getReadinessProbe();
    public io.fabric8.kubernetes.api.model.Probe buildReadinessProbe();
    public A withReadinessProbe(io.fabric8.kubernetes.api.model.Probe readinessProbe);
    public java.lang.Boolean hasReadinessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildResources instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ResourceRequirements getResources();
    public io.fabric8.kubernetes.api.model.ResourceRequirements buildResources();
    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources);
    public java.lang.Boolean hasResources();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> withNewResources();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> withNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editResources();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editOrNewResources();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<A> editOrNewResourcesLike(io.fabric8.kubernetes.api.model.ResourceRequirements item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecurityContext instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.SecurityContext getSecurityContext();
    public io.fabric8.kubernetes.api.model.SecurityContext buildSecurityContext();
    public A withSecurityContext(io.fabric8.kubernetes.api.model.SecurityContext securityContext);
    public java.lang.Boolean hasSecurityContext();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContext();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(io.fabric8.kubernetes.api.model.SecurityContext item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editSecurityContext();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContext();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(io.fabric8.kubernetes.api.model.SecurityContext item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStartupProbe instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.Probe getStartupProbe();
    public io.fabric8.kubernetes.api.model.Probe buildStartupProbe();
    public A withStartupProbe(io.fabric8.kubernetes.api.model.Probe startupProbe);
    public java.lang.Boolean hasStartupProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editStartupProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbe();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(io.fabric8.kubernetes.api.model.Probe item);
    public java.lang.Boolean getStdin();
    public A withStdin(java.lang.Boolean stdin);
    public java.lang.Boolean hasStdin();
    public java.lang.Boolean getStdinOnce();
    public A withStdinOnce(java.lang.Boolean stdinOnce);
    public java.lang.Boolean hasStdinOnce();
    public java.lang.String getTargetContainerName();
    public A withTargetContainerName(java.lang.String targetContainerName);
    public java.lang.Boolean hasTargetContainerName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTargetContainerName instead.
     */
        public A withNewTargetContainerName(java.lang.String arg0);
    public java.lang.String getTerminationMessagePath();
    public A withTerminationMessagePath(java.lang.String terminationMessagePath);
    public java.lang.Boolean hasTerminationMessagePath();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTerminationMessagePath instead.
     */
        public A withNewTerminationMessagePath(java.lang.String arg0);
    public java.lang.String getTerminationMessagePolicy();
    public A withTerminationMessagePolicy(java.lang.String terminationMessagePolicy);
    public java.lang.Boolean hasTerminationMessagePolicy();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTerminationMessagePolicy instead.
     */
        public A withNewTerminationMessagePolicy(java.lang.String arg0);
    public java.lang.Boolean getTty();
    public A withTty(java.lang.Boolean tty);
    public java.lang.Boolean hasTty();
    public A addToVolumeDevices(int index,io.fabric8.kubernetes.api.model.VolumeDevice item);
    public A setToVolumeDevices(int index,io.fabric8.kubernetes.api.model.VolumeDevice item);
    public A addToVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items);
    public A addAllToVolumeDevices(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeDevice> items);
    public A removeFromVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items);
    public A removeAllFromVolumeDevices(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeDevice> items);
    public A removeMatchingFromVolumeDevices(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeDevices instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> getVolumeDevices();
    public java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> buildVolumeDevices();
    public io.fabric8.kubernetes.api.model.VolumeDevice buildVolumeDevice(int index);
    public io.fabric8.kubernetes.api.model.VolumeDevice buildFirstVolumeDevice();
    public io.fabric8.kubernetes.api.model.VolumeDevice buildLastVolumeDevice();
    public io.fabric8.kubernetes.api.model.VolumeDevice buildMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate);
    public java.lang.Boolean hasMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate);
    public A withVolumeDevices(java.util.List<io.fabric8.kubernetes.api.model.VolumeDevice> volumeDevices);
    public A withVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... volumeDevices);
    public java.lang.Boolean hasVolumeDevices();
    public A addNewVolumeDevice(java.lang.String devicePath,java.lang.String name);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(io.fabric8.kubernetes.api.model.VolumeDevice item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index,io.fabric8.kubernetes.api.model.VolumeDevice item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeDeviceBuilder> predicate);
    public A addToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item);
    public A setToVolumeMounts(int index,io.fabric8.kubernetes.api.model.VolumeMount item);
    public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
    public A addAllToVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items);
    public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items);
    public A removeAllFromVolumeMounts(java.util.Collection<io.fabric8.kubernetes.api.model.VolumeMount> items);
    public A removeMatchingFromVolumeMounts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumeMounts instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> getVolumeMounts();
    public java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> buildVolumeMounts();
    public io.fabric8.kubernetes.api.model.VolumeMount buildVolumeMount(int index);
    public io.fabric8.kubernetes.api.model.VolumeMount buildFirstVolumeMount();
    public io.fabric8.kubernetes.api.model.VolumeMount buildLastVolumeMount();
    public io.fabric8.kubernetes.api.model.VolumeMount buildMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate);
    public java.lang.Boolean hasMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate);
    public A withVolumeMounts(java.util.List<io.fabric8.kubernetes.api.model.VolumeMount> volumeMounts);
    public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts);
    public java.lang.Boolean hasVolumeMounts();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMount();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(io.fabric8.kubernetes.api.model.VolumeMount item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,io.fabric8.kubernetes.api.model.VolumeMount item);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editVolumeMount(int index);
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editFirstVolumeMount();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editLastVolumeMount();
    public io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeMountBuilder> predicate);
    public java.lang.String getWorkingDir();
    public A withWorkingDir(java.lang.String workingDir);
    public java.lang.Boolean hasWorkingDir();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withWorkingDir instead.
     */
        public A withNewWorkingDir(java.lang.String arg0);
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EnvVarFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


    public interface EnvFromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.EnvFromSourceFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.EnvFromNested<N>> {

            public N and();
            public N endEnvFrom();    }


    public interface LifecycleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.LifecycleFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LifecycleNested<N>> {

            public N and();
            public N endLifecycle();    }


    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ProbeFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ContainerPortFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ProbeFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


    public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.SecurityContextFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.SecurityContextNested<N>> {

            public N and();
            public N endSecurityContext();    }


    public interface StartupProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ProbeFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.StartupProbeNested<N>> {

            public N and();
            public N endStartupProbe();    }


    public interface VolumeDevicesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.VolumeDeviceFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeDevicesNested<N>> {

            public N and();
            public N endVolumeDevice();    }


    public interface VolumeMountsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.VolumeMountFluent<io.fabric8.kubernetes.api.model.EphemeralContainerFluent.VolumeMountsNested<N>> {

            public N and();
            public N endVolumeMount();    }


}
