package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExecActionBuilder extends io.fabric8.kubernetes.api.model.ExecActionFluentImpl<io.fabric8.kubernetes.api.model.ExecActionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ExecAction,io.fabric8.kubernetes.api.model.ExecActionBuilder> {

    io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExecActionBuilder() {
        this(true);
    }

    public ExecActionBuilder(java.lang.Boolean validationEnabled) {
        this(new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent) {
        this(fluent, true);
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecAction instance) {
        this(fluent, instance, true);
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecActionFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecAction instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCommand(instance.getCommand()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecAction instance) {
        this(instance,true);
    }

    public ExecActionBuilder(io.fabric8.kubernetes.api.model.ExecAction instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCommand(instance.getCommand()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.ExecAction build() {
        ExecAction buildable = new ExecAction(fluent.getCommand());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExecActionBuilder that = (ExecActionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
