package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LocalVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.LocalVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LocalVolumeSource,io.fabric8.kubernetes.api.model.LocalVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public LocalVolumeSourceBuilder() {
        this(true);
    }

    public LocalVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new LocalVolumeSource(), validationEnabled);
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new LocalVolumeSource(), validationEnabled);
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalVolumeSource instance) {
        this(fluent, instance, true);
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.LocalVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withPath(instance.getPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSource instance) {
        this(instance,true);
    }

    public LocalVolumeSourceBuilder(io.fabric8.kubernetes.api.model.LocalVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withPath(instance.getPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.LocalVolumeSource build() {
        LocalVolumeSource buildable = new LocalVolumeSource(fluent.getFsType(),fluent.getPath());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LocalVolumeSourceBuilder that = (LocalVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
